/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.openapi.validation.OpenApiValidationContext;
import org.citrusframework.openapi.validation.OpenApiValidationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenApiValidationContextLoader {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiValidationContextLoader.class);
    private static final Set<String> apisWithLoggedValidationErrors = new HashSet<String>();

    private OpenApiValidationContextLoader() {
    }

    public static OpenApiValidationContext fromSpec(String openApiSpecAsString, OpenApiValidationPolicy openApiValidationPolicy) {
        OpenAPIParser openAPIParser = new OpenAPIParser();
        return OpenApiValidationContextLoader.createValidationContext(OpenApiValidationContextLoader.handleSwaggerParserResult(openApiSpecAsString, openAPIParser.readContents(openApiSpecAsString, Collections.emptyList(), OpenApiValidationContextLoader.defaultParseOptions()), openApiValidationPolicy));
    }

    private static OpenAPI handleSwaggerParserResult(String identifier, SwaggerParseResult swaggerParseResult, OpenApiValidationPolicy openApiValidationPolicy) {
        logger.trace("Handling swagger parser result: {}", (Object)swaggerParseResult);
        if (swaggerParseResult == null) {
            throw new CitrusRuntimeException("Unable to parse OpenApi from specSource: " + identifier);
        }
        if (OpenApiValidationContextLoader.hasParseErrors(swaggerParseResult)) {
            OpenApiValidationContextLoader.handleValidationException(identifier, openApiValidationPolicy, swaggerParseResult.getMessages());
        }
        return swaggerParseResult.getOpenAPI();
    }

    private static boolean hasParseErrors(@Nullable SwaggerParseResult parseResult) {
        if (parseResult == null || parseResult.getOpenAPI() == null) {
            return true;
        }
        return parseResult.getMessages() != null && !parseResult.getMessages().isEmpty();
    }

    private static void handleValidationException(String identifier, OpenApiValidationPolicy openApiValidationPolicy, List<String> errorMessages) {
        if (OpenApiValidationPolicy.REPORT.equals((Object)openApiValidationPolicy) && !apisWithLoggedValidationErrors.contains(identifier)) {
            apisWithLoggedValidationErrors.add(identifier);
            logger.warn("OpenApi '{}' has validation errors {}", (Object)identifier, errorMessages);
        } else if (OpenApiValidationPolicy.STRICT.equals((Object)openApiValidationPolicy)) {
            throw new ValidationException(String.format("The API '%s' has failed STRICT validation:\n%s\n", identifier, String.join((CharSequence)",", errorMessages)));
        }
    }

    private static OpenApiValidationContext createValidationContext(OpenAPI openApi) {
        return new OpenApiValidationContext(openApi);
    }

    private static ParseOptions defaultParseOptions() {
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setResolveFully(true);
        parseOptions.setResolveCombinators(false);
        return parseOptions;
    }
}

