/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.atlassian.oai.validator.schema.SwaggerV20Library;
import com.atlassian.oai.validator.whitelist.ValidationErrorsWhitelist;
import com.atlassian.oai.validator.whitelist.rule.WhitelistRule;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.annotation.Nonnull;
import java.util.List;
import javax.annotation.Nullable;

public class OpenApiValidationContext {
    private static final List<IgnoreByKeyWhitelistRule> WHITELIST_RULES = List.of(IgnoreByKeyWhitelistRule.ignoreByKey("Allow unknown response status rule", "validation.response.status.unknown"));
    private final OpenAPI openApi;
    private OpenApiInteractionValidator openApiInteractionValidator;
    private SchemaValidator schemaValidator;
    private boolean responseValidationEnabled = this.isResponseValidationEnabled();
    private boolean requestValidationEnabled = this.isRequestValidationEnabled();
    private static final ValidationErrorsWhitelist validationErrorsWhitelist;

    public OpenApiValidationContext(OpenAPI openApi) {
        this.openApi = openApi;
    }

    public OpenAPI getSwaggerOpenApi() {
        return this.openApi;
    }

    @Nonnull
    public synchronized OpenApiInteractionValidator getOpenApiInteractionValidator() {
        if (this.openApiInteractionValidator == null) {
            this.openApiInteractionValidator = new OpenApiInteractionValidator.Builder().withApi(this.openApi).withWhitelist(validationErrorsWhitelist).build();
        }
        return this.openApiInteractionValidator;
    }

    @Nonnull
    public synchronized SchemaValidator getSchemaValidator() {
        if (this.schemaValidator == null) {
            this.schemaValidator = new SchemaValidator(this.openApi, new MessageResolver(), SwaggerV20Library::schemaFactory);
        }
        return this.schemaValidator;
    }

    public boolean isResponseValidationEnabled() {
        return this.responseValidationEnabled;
    }

    public void setResponseValidationEnabled(boolean responseValidationEnabled) {
        this.responseValidationEnabled = responseValidationEnabled;
    }

    public boolean isRequestValidationEnabled() {
        return this.requestValidationEnabled;
    }

    public void setRequestValidationEnabled(boolean requestValidationEnabled) {
        this.requestValidationEnabled = requestValidationEnabled;
    }

    static {
        ValidationErrorsWhitelist whiteList = ValidationErrorsWhitelist.create();
        for (IgnoreByKeyWhitelistRule rule : WHITELIST_RULES) {
            whiteList = whiteList.withRule(rule.name, (WhitelistRule)rule);
        }
        validationErrorsWhitelist = whiteList;
    }

    private static class IgnoreByKeyWhitelistRule
    implements WhitelistRule {
        private final String name;
        private final String key;

        private IgnoreByKeyWhitelistRule(@Nonnull String name, @Nonnull String key) {
            this.name = name;
            this.key = key;
        }

        public boolean matches(ValidationReport.Message message, @Nullable ApiOperation operation, @Nullable Request request, @Nullable Response response) {
            return this.key.equals(message.getKey());
        }

        public static IgnoreByKeyWhitelistRule ignoreByKey(String name, String key) {
            return new IgnoreByKeyWhitelistRule(name, key);
        }
    }
}

