/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation;

import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.validation.OpenApiValidator;
import org.springframework.http.HttpStatusCode;

public class OpenApiResponseValidator
extends OpenApiValidator {
    public OpenApiResponseValidator(OpenApiSpecification openApiSpecification) {
        super(openApiSpecification);
    }

    @Override
    protected String getType() {
        return "response";
    }

    public void validateResponse(OperationPathAdapter operationPathAdapter, HttpMessage httpMessage) {
        if (this.openApiInteractionValidator != null) {
            HttpStatusCode statusCode = httpMessage.getStatusCode();
            Response response = this.createResponseFromMessage(httpMessage, statusCode != null ? Integer.valueOf(statusCode.value()) : null);
            ValidationReport validationReport = this.openApiInteractionValidator.validateResponse(operationPathAdapter.apiPath(), Request.Method.valueOf((String)operationPathAdapter.operation().getMethod().toUpperCase()), response);
            if (validationReport.hasErrors()) {
                throw new ValidationException(this.constructErrorMessage(operationPathAdapter, validationReport));
            }
        }
    }

    public ValidationReport validateResponseToReport(OperationPathAdapter operationPathAdapter, HttpMessage httpMessage) {
        if (this.openApiInteractionValidator != null) {
            HttpStatusCode statusCode = httpMessage.getStatusCode();
            Response response = this.createResponseFromMessage(httpMessage, statusCode != null ? Integer.valueOf(statusCode.value()) : null);
            return this.openApiInteractionValidator.validateResponse(operationPathAdapter.apiPath(), Request.Method.valueOf((String)operationPathAdapter.operation().getMethod().toUpperCase()), response);
        }
        return ValidationReport.empty();
    }

    Response createResponseFromMessage(HttpMessage message, Integer statusCode) {
        Object payload = message.getPayload();
        SimpleResponse.Builder responseBuilder = new SimpleResponse.Builder(statusCode.intValue());
        if (payload != null) {
            responseBuilder = responseBuilder.withBody(payload.toString());
        }
        SimpleResponse.Builder finalResponseBuilder = responseBuilder;
        message.getHeaders().forEach((key, value) -> finalResponseBuilder.withHeader(key, new String[]{value != null ? value.toString() : null}));
        return responseBuilder.build();
    }
}

