/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.validation;

import org.citrusframework.context.TestContext;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.openapi.OpenApiMessageType;
import org.citrusframework.openapi.OpenApiSpecification;

public class OpenApiOperationToMessageHeadersProcessor
implements MessageProcessor {
    private final OpenApiSpecification openApiSpecification;
    private final String operationKey;
    private final OpenApiMessageType type;

    public OpenApiOperationToMessageHeadersProcessor(OpenApiSpecification openApiSpecification, String operationKey, OpenApiMessageType type) {
        this.operationKey = operationKey;
        this.openApiSpecification = openApiSpecification;
        this.type = type;
    }

    public void process(Message message, TestContext context) {
        this.openApiSpecification.getOperation(this.operationKey, context).ifPresent(operationPathAdapter -> {
            message.setHeader("citrus_oas_unique_specification_id", (Object)this.openApiSpecification.getUid());
            message.setHeader("citrus_oas_unique_operation_id", (Object)operationPathAdapter.uniqueOperationId());
            message.setHeader("citrus_oas_message_type", (Object)this.type.toHeaderName());
        });
    }
}

