/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import java.util.ArrayDeque;
import java.util.Deque;
import org.citrusframework.openapi.random.RandomElement;
import org.citrusframework.openapi.random.RandomModelJsonWriter;

public class RandomModelBuilder {
    final Deque<RandomElement> deque = new ArrayDeque<RandomElement>();
    private final boolean quote;

    public RandomModelBuilder(boolean quote) {
        this.deque.push(new RandomElement.RandomValue());
        this.quote = quote;
    }

    public String writeToJson() {
        return RandomModelJsonWriter.toString(this);
    }

    public void appendSimple(String simpleValue) {
        if (this.deque.isEmpty()) {
            this.deque.push(new RandomElement.RandomValue(simpleValue));
        } else {
            this.deque.peek().push(new RandomElement.RandomValue(simpleValue));
        }
    }

    public void appendSimpleQuoted(String simpleValue) {
        this.appendSimple(this.quote(simpleValue));
    }

    public void object(Runnable objectBuilder) {
        this.assertItemsInDequeOrThrow();
        RandomElement.RandomObject randomObject = new RandomElement.RandomObject();
        this.deque.peek().push(randomObject);
        objectBuilder.run();
    }

    public void property(String key, Runnable valueBuilder) {
        this.assertItemsInDequeOrThrow();
        RandomElement.RandomValue randomValue = new RandomElement.RandomValue();
        this.deque.peek().push(key, randomValue);
        this.deque.push(randomValue);
        valueBuilder.run();
        this.deque.pop();
    }

    public void array(Runnable arrayBuilder) {
        this.assertItemsInDequeOrThrow();
        RandomElement.RandomList randomList = new RandomElement.RandomList();
        this.deque.peek().push(randomList);
        this.deque.push(randomList);
        arrayBuilder.run();
        this.deque.pop();
    }

    private String quote(String text) {
        return this.quote ? String.format("\"%s\"", text) : text;
    }

    private void assertItemsInDequeOrThrow() {
        if (this.deque.isEmpty()) {
            throw new IllegalStateException("Encountered empty stack!");
        }
    }
}

