/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.citrusframework.openapi.random.RandomContext;
import org.citrusframework.openapi.random.RandomGenerator;

public class RandomGeneratorBuilder {
    private final OasSchema schema = new Oas30Schema();

    private RandomGeneratorBuilder() {
    }

    static RandomGeneratorBuilder randomGeneratorBuilder() {
        return new RandomGeneratorBuilder();
    }

    static RandomGeneratorBuilder randomGeneratorBuilder(String type, String format) {
        return new RandomGeneratorBuilder().with(type, format);
    }

    RandomGeneratorBuilder with(String type, String format) {
        this.schema.type = type;
        this.schema.format = format;
        return this;
    }

    RandomGeneratorBuilder withType(String type) {
        this.schema.type = type;
        return this;
    }

    RandomGeneratorBuilder withFormat(String format) {
        this.schema.format = format;
        return this;
    }

    RandomGeneratorBuilder withPattern(String pattern) {
        this.schema.pattern = pattern;
        return this;
    }

    RandomGeneratorBuilder withEnum() {
        this.schema.enum_ = Collections.emptyList();
        return this;
    }

    RandomGenerator build(final BiConsumer<RandomContext, OasSchema> consumer) {
        return new RandomGenerator(this.schema){

            @Override
            void generateIntoContext(RandomContext randomContext, OasSchema schema) {
                consumer.accept(randomContext, schema);
            }
        };
    }
}

