/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.random;

import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.concurrent.ThreadLocalRandom;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.openapi.random.RandomContext;
import org.citrusframework.openapi.random.RandomGenerator;

public class RandomArrayGenerator
extends RandomGenerator {
    private static void createRandomArrayValueWithSchemaItem(RandomContext randomContext, OasSchema schema, OasSchema itemsSchema) {
        Number minItems = schema.minItems != null ? (Number)schema.minItems : (Number)1;
        Number maxItems = schema.maxItems != null ? (Number)schema.maxItems : (Number)10;
        int nItems = ThreadLocalRandom.current().nextInt(minItems.intValue(), maxItems.intValue() + 1);
        randomContext.getRandomModelBuilder().array(() -> {
            for (int i = 0; i < nItems; ++i) {
                randomContext.generate(itemsSchema);
            }
        });
    }

    @Override
    public boolean handles(OasSchema other) {
        return OasModelHelper.isArrayType(other);
    }

    @Override
    void generateIntoContext(RandomContext randomContext, OasSchema schema) {
        Object items = schema.items;
        if (!(items instanceof OasSchema)) {
            throw new UnsupportedOperationException("Random array creation for an array with items having different schema is currently not supported!");
        }
        OasSchema itemsSchema = (OasSchema)items;
        RandomArrayGenerator.createRandomArrayValueWithSchemaItem(randomContext, schema, itemsSchema);
    }
}

