/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.model.v2;

import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Header;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.citrusframework.openapi.model.OasAdapter;
import org.citrusframework.openapi.model.OasModelHelper;

public final class Oas20ModelHelper {
    private static Set<String> FORM_TYPES = Set.of("application/x-www-form-urlencoded", "multipart/form-data");

    private Oas20ModelHelper() {
    }

    public static String getHost(Oas20Document openApiDoc) {
        return openApiDoc.host;
    }

    public static List<String> getSchemes(Oas20Document openApiDoc) {
        return openApiDoc.schemes;
    }

    public static String getBasePath(Oas20Document openApiDoc) {
        return Optional.ofNullable(openApiDoc.basePath).map(basePath -> basePath.startsWith("/") ? basePath : "/" + basePath).orElse("/");
    }

    public static Map<String, OasSchema> getSchemaDefinitions(Oas20Document openApiDoc) {
        if (openApiDoc == null || openApiDoc.definitions == null) {
            return Collections.emptyMap();
        }
        return openApiDoc.definitions.getDefinitions().stream().collect(Collectors.toMap(Oas20SchemaDefinition::getName, definition -> definition));
    }

    public static Optional<OasSchema> getSchema(Oas20Response response) {
        return Optional.ofNullable(response.schema);
    }

    public static Optional<OasAdapter<OasSchema, String>> getSchema(Oas20Operation oas20Operation, Oas20Response response, List<String> acceptedMediaTypes) {
        acceptedMediaTypes = (acceptedMediaTypes = OasModelHelper.resolveAllTypes(acceptedMediaTypes)).isEmpty() ? OasModelHelper.DEFAULT_ACCEPTED_MEDIA_TYPES : acceptedMediaTypes;
        Oas20Schema selectedSchema = response.schema;
        String selectedMediaType = null;
        if (oas20Operation.produces != null && !oas20Operation.produces.isEmpty()) {
            selectedMediaType = acceptedMediaTypes.stream().filter(type -> !Oas20ModelHelper.isFormDataMediaType(type)).filter(type -> oas20Operation.produces.contains(type)).findFirst().orElse(null);
        }
        return selectedSchema == null && selectedMediaType == null ? Optional.empty() : Optional.of(new OasAdapter<Oas20Schema, Object>(selectedSchema, selectedMediaType));
    }

    public static boolean isCompositeSchema(Oas20Schema schema) {
        return schema instanceof Oas20Schema.Oas20AllOfSchema;
    }

    public static Optional<OasSchema> getRequestBodySchema(@Nullable Oas20Document ignoredOpenApiDoc, Oas20Operation operation) {
        return Oas20ModelHelper.getOperationRequestBodyParameter(operation).map(oasParameter -> (OasSchema)oasParameter.schema);
    }

    public static boolean isOperationRequestBodyRequired(@Nullable Oas20Document ignoredOpenApiDoc, Oas20Operation operation) {
        return Oas20ModelHelper.getOperationRequestBodyParameter(operation).isPresent();
    }

    private static Optional<OasParameter> getOperationRequestBodyParameter(Oas20Operation operation) {
        if (operation.parameters == null) {
            return Optional.empty();
        }
        List operationParameters = operation.parameters;
        return operationParameters.stream().filter(p -> "body".equals(p.in) && p.schema != null && Boolean.TRUE == p.required).findFirst();
    }

    public static Optional<String> getRequestContentType(Oas20Operation operation) {
        if (operation.consumes != null) {
            return Optional.of((String)operation.consumes.get(0));
        }
        return Optional.empty();
    }

    public static Collection<String> getResponseTypes(Oas20Operation operation, @Nullable Oas20Response ignoredResponse) {
        if (operation == null) {
            return Collections.emptyList();
        }
        return operation.produces;
    }

    public static Map<String, OasSchema> getHeaders(Oas20Response response) {
        if (response.headers == null) {
            return Collections.emptyMap();
        }
        return response.headers.getHeaders().stream().collect(Collectors.toMap(OasHeader::getName, Oas20ModelHelper::getHeaderSchema));
    }

    private static boolean isFormDataMediaType(String type) {
        return FORM_TYPES.contains(type);
    }

    private static OasSchema getHeaderSchema(Oas20Header header) {
        return Oas20ModelHelper.createOas20Schema(header.getName(), header.type, header.format, header.items, header.multipleOf, header.default_, header.enum_, header.pattern, header.description, header.uniqueItems, header.maximum, header.maxItems, header.maxLength, header.exclusiveMaximum, header.minimum, header.minItems, header.minLength, header.exclusiveMinimum);
    }

    public static Optional<OasSchema> getParameterSchema(Oas20Parameter parameter) {
        Schema schema = parameter.schema;
        if (schema instanceof Oas20Schema) {
            Oas20Schema oasSchema = (Oas20Schema)schema;
            return Optional.of(oasSchema);
        }
        Oas20Schema schema2 = Oas20ModelHelper.createOas20Schema(parameter.getName(), parameter.type, parameter.format, parameter.items, parameter.multipleOf, parameter.default_, parameter.enum_, parameter.pattern, parameter.description, parameter.uniqueItems, parameter.maximum, parameter.maxItems, parameter.maxLength, parameter.exclusiveMaximum, parameter.minimum, parameter.minItems, parameter.minLength, parameter.exclusiveMinimum);
        return Optional.of(schema2);
    }

    private static Oas20Schema createOas20Schema(String name, String type, String format, Oas20Items items, Number multipleOf, Object aDefault, List<String> anEnum, String pattern, String description, Boolean uniqueItems, Number maximum, Number maxItems, Number maxLength, Boolean exclusiveMaximum, Number minimum, Number minItems, Number minLength, Boolean exclusiveMinimum) {
        Oas20Schema schema = new Oas20Schema();
        schema.title = name;
        schema.type = type;
        schema.format = format;
        schema.items = items;
        schema.multipleOf = multipleOf;
        schema.default_ = aDefault;
        schema.enum_ = anEnum;
        schema.pattern = pattern;
        schema.description = description;
        schema.uniqueItems = uniqueItems;
        schema.maximum = maximum;
        schema.maxItems = maxItems;
        schema.maxLength = maxLength;
        schema.exclusiveMaximum = exclusiveMaximum;
        schema.minimum = minimum;
        schema.minItems = minItems;
        schema.minLength = minLength;
        schema.exclusiveMinimum = exclusiveMinimum;
        return schema;
    }
}

