/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.model;

import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasPaths;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasResponses;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.io.Oas20DataModelWriter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.visitors.IOas20Visitor;
import io.apicurio.datamodels.openapi.v2.visitors.Oas20Traverser;
import io.apicurio.datamodels.openapi.v3.io.Oas30DataModelWriter;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Operation;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import io.apicurio.datamodels.openapi.v3.visitors.IOas30Visitor;
import io.apicurio.datamodels.openapi.v3.visitors.Oas30Traverser;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.citrusframework.openapi.model.OasAdapter;
import org.citrusframework.openapi.model.OasOperationVisitor;
import org.citrusframework.openapi.model.OpenApiVersion;
import org.citrusframework.openapi.model.v2.Oas20ModelHelper;
import org.citrusframework.openapi.model.v3.Oas30ModelHelper;
import org.citrusframework.util.StringUtils;

public final class OasModelHelper {
    public static final String DEFAULT = "default_";
    public static final List<String> DEFAULT_ACCEPTED_MEDIA_TYPES = List.of("application/json", "text/plain");

    private OasModelHelper() {
    }

    public static boolean isObjectType(@Nullable OasSchema schema) {
        return schema != null && "object".equals(schema.type);
    }

    public static boolean isArrayType(@Nullable OasSchema schema) {
        return schema != null && "array".equals(schema.type);
    }

    public static boolean isObjectArrayType(@Nullable OasSchema schema) {
        if (schema == null || !"array".equals(schema.type)) {
            return false;
        }
        Object items = schema.items;
        if (items instanceof OasSchema) {
            OasSchema oasSchema = (OasSchema)items;
            return OasModelHelper.isObjectType(oasSchema);
        }
        if (items instanceof List) {
            List list = (List)items;
            return list.stream().allMatch(item -> {
                OasSchema oasSchema;
                return item instanceof OasSchema && OasModelHelper.isObjectType(oasSchema = (OasSchema)item);
            });
        }
        return false;
    }

    public static boolean isReferenceType(@Nullable OasSchema schema) {
        return schema != null && schema.$ref != null;
    }

    public static boolean isCompositeSchema(OasSchema schema) {
        return OasModelHelper.delegate(schema, Oas20ModelHelper::isCompositeSchema, Oas30ModelHelper::isCompositeSchema);
    }

    public static String getHost(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, Oas20ModelHelper::getHost, Oas30ModelHelper::getHost);
    }

    public static List<String> getSchemes(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, Oas20ModelHelper::getSchemes, Oas30ModelHelper::getSchemes);
    }

    public static OasSchema resolveSchema(OasDocument oasDocument, OasSchema schema) {
        if (OasModelHelper.isReferenceType(schema)) {
            return OasModelHelper.getSchemaDefinitions(oasDocument).get(OasModelHelper.getReferenceName(schema.$ref));
        }
        return schema;
    }

    public static String getBasePath(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, Oas20ModelHelper::getBasePath, Oas30ModelHelper::getBasePath);
    }

    public static Map<String, OasSchema> getSchemaDefinitions(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, Oas20ModelHelper::getSchemaDefinitions, Oas30ModelHelper::getSchemaDefinitions);
    }

    public static List<OasPathItem> getPathItems(OasPaths paths) {
        if (paths == null) {
            return Collections.emptyList();
        }
        return paths.getItems();
    }

    public static Map<String, OasOperation> getOperationMap(OasPathItem pathItem) {
        LinkedHashMap<String, OasOperation> operations = new LinkedHashMap<String, OasOperation>();
        if (pathItem.get != null) {
            operations.put("get", pathItem.get);
        }
        if (pathItem.put != null) {
            operations.put("put", pathItem.put);
        }
        if (pathItem.post != null) {
            operations.put("post", pathItem.post);
        }
        if (pathItem.delete != null) {
            operations.put("delete", pathItem.delete);
        }
        if (pathItem.options != null) {
            operations.put("options", pathItem.options);
        }
        if (pathItem.head != null) {
            operations.put("head", pathItem.head);
        }
        if (pathItem.patch != null) {
            operations.put("patch", pathItem.patch);
        }
        return operations;
    }

    public static String getReferenceName(String reference) {
        if (reference != null) {
            return reference.replaceAll("^.*/", "");
        }
        return null;
    }

    public static Optional<OasSchema> getSchema(OasResponse response) {
        return OasModelHelper.delegate(response, Oas20ModelHelper::getSchema, Oas30ModelHelper::getSchema);
    }

    public static Optional<OasAdapter<OasSchema, String>> getSchema(OasOperation oasOperation, OasResponse response, List<String> acceptedMediaTypes) {
        if (oasOperation instanceof Oas20Operation) {
            Oas20Operation oas20Operation = (Oas20Operation)oasOperation;
            if (response instanceof Oas20Response) {
                Oas20Response oas20Response = (Oas20Response)response;
                return Oas20ModelHelper.getSchema(oas20Operation, oas20Response, acceptedMediaTypes);
            }
        }
        if (oasOperation instanceof Oas30Operation) {
            Oas30Operation oas30Operation = (Oas30Operation)oasOperation;
            if (response instanceof Oas30Response) {
                Oas30Response oas30Response = (Oas30Response)response;
                return Oas30ModelHelper.getSchema(oas30Operation, oas30Response, acceptedMediaTypes);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported operation response type: %s", response.getClass()));
    }

    public static Optional<OasAdapter<OasSchema, String>> getRandomizableSchema(OasOperation oasOperation, OasResponse response, String acceptedMediaTypes) {
        List<String> acceptedRandomizableMediaTypes = OasModelHelper.toAcceptedRandomizableMediaTypes(acceptedMediaTypes);
        if (oasOperation instanceof Oas20Operation) {
            Oas20Operation oas20Operation = (Oas20Operation)oasOperation;
            if (response instanceof Oas20Response) {
                Oas20Response oas20Response = (Oas20Response)response;
                return Oas20ModelHelper.getSchema(oas20Operation, oas20Response, acceptedRandomizableMediaTypes);
            }
        }
        if (oasOperation instanceof Oas30Operation) {
            Oas30Operation oas30Operation = (Oas30Operation)oasOperation;
            if (response instanceof Oas30Response) {
                Oas30Response oas30Response = (Oas30Response)response;
                return Oas30ModelHelper.getSchema(oas30Operation, oas30Response, acceptedRandomizableMediaTypes);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported operation response type: %s", response.getClass()));
    }

    public static Optional<OasSchema> getParameterSchema(OasParameter parameter) {
        return OasModelHelper.delegate(parameter, Oas20ModelHelper::getParameterSchema, Oas30ModelHelper::getParameterSchema);
    }

    public static Map<String, OasSchema> getRequiredHeaders(OasDocument oasDocument, OasResponse response) {
        return OasModelHelper.delegate(response, Oas20ModelHelper::getHeaders, (Oas30Response r) -> Oas30ModelHelper.getRequiredHeaders((Oas30Document)Oas30Document.class.cast(oasDocument), r));
    }

    public static Map<String, OasSchema> getHeaders(OasDocument oasDocument, OasResponse response) {
        return OasModelHelper.delegate(response, Oas20ModelHelper::getHeaders, (Oas30Response r) -> Oas30ModelHelper.getHeaders((Oas30Document)Oas30Document.class.cast(oasDocument), r));
    }

    public static Optional<String> getRequestContentType(OasOperation operation) {
        return OasModelHelper.delegate(operation, Oas20ModelHelper::getRequestContentType, Oas30ModelHelper::getRequestContentType);
    }

    public static Optional<OasSchema> getRequestBodySchema(OasDocument openApiDoc, OasOperation operation) {
        return OasModelHelper.delegate(openApiDoc, operation, Oas20ModelHelper::getRequestBodySchema, Oas30ModelHelper::getRequestBodySchema);
    }

    public static boolean isOperationRequestBodyRequired(OasDocument openApiDoc, OasOperation operation) {
        return OasModelHelper.delegate(openApiDoc, operation, Oas20ModelHelper::isOperationRequestBodyRequired, Oas30ModelHelper::isOperationRequestBodyRequired);
    }

    public static Collection<String> getResponseTypes(OasOperation operation, OasResponse response) {
        return OasModelHelper.delegate(operation, response, Oas20ModelHelper::getResponseTypes, Oas30ModelHelper::getResponseTypes);
    }

    public static Optional<OasResponse> getResponseForRandomGeneration(OasDocument openApiDoc, OasOperation operation, @Nullable String statusCode, @Nullable String accept) {
        if (operation.responses == null || operation.responses.getResponses().isEmpty()) {
            return Optional.empty();
        }
        Map<String, OasResponse> responseMap = OasModelHelper.resolveResponses(openApiDoc, operation.responses);
        if (StringUtils.isNotEmpty((String)statusCode)) {
            return Optional.ofNullable(responseMap.get(statusCode));
        }
        Optional<OasResponse> response = Optional.ofNullable(responseMap.get(DEFAULT));
        if (response.isEmpty()) {
            List<String> acceptedMediaTypesForRandomGeneration = OasModelHelper.toAcceptedRandomizableMediaTypes(accept);
            Predicate<OasResponse> acceptableResponseWithRandomizableSchema = resp -> OasModelHelper.getSchema(operation, resp, acceptedMediaTypesForRandomGeneration).isPresent();
            response = responseMap.values().stream().filter(r -> r.getStatusCode() != null && r.getStatusCode().startsWith("2")).map(OasResponse.class::cast).filter(acceptableResponseWithRandomizableSchema).findFirst();
        }
        if (response.isEmpty()) {
            response = responseMap.values().stream().filter(r -> r.getStatusCode() != null && r.getStatusCode().startsWith("2")).map(OasResponse.class::cast).findFirst();
        }
        if (response.isEmpty()) {
            response = operation.responses.getResponses().stream().map(resp -> (OasResponse)responseMap.get(resp.getStatusCode())).filter(Objects::nonNull).findFirst();
        }
        return response;
    }

    private static <T> T delegate(OasDocument openApiDoc, Function<Oas20Document, T> oas20Function, Function<Oas30Document, T> oas30Function) {
        if (OasModelHelper.isOas20(openApiDoc)) {
            return oas20Function.apply((Oas20Document)openApiDoc);
        }
        if (OasModelHelper.isOas30(openApiDoc)) {
            return oas30Function.apply((Oas30Document)openApiDoc);
        }
        throw new IllegalArgumentException(String.format("Unsupported Open API document type: %s", openApiDoc.getClass()));
    }

    private static <T> T delegate(OasResponse response, Function<Oas20Response, T> oas20Function, Function<Oas30Response, T> oas30Function) {
        if (response instanceof Oas20Response) {
            Oas20Response oas20Response = (Oas20Response)response;
            return oas20Function.apply(oas20Response);
        }
        if (response instanceof Oas30Response) {
            Oas30Response oas30Response = (Oas30Response)response;
            return oas30Function.apply(oas30Response);
        }
        throw new IllegalArgumentException(String.format("Unsupported operation response type: %s", response.getClass()));
    }

    private static <T> T delegate(OasOperation operation, OasResponse response, BiFunction<Oas20Operation, Oas20Response, T> oas20Function, BiFunction<Oas30Operation, Oas30Response, T> oas30Function) {
        if (operation instanceof Oas20Operation) {
            Oas20Operation oas20Operation = (Oas20Operation)operation;
            if (response instanceof Oas20Response) {
                Oas20Response oas20Response = (Oas20Response)response;
                return oas20Function.apply(oas20Operation, oas20Response);
            }
        }
        if (operation instanceof Oas30Operation) {
            Oas30Operation oas30Operation = (Oas30Operation)operation;
            if (response instanceof Oas30Response) {
                Oas30Response oas30Response = (Oas30Response)response;
                return oas30Function.apply(oas30Operation, oas30Response);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported operation response type: %s", response.getClass()));
    }

    private static <T> T delegate(OasParameter parameter, Function<Oas20Parameter, T> oas20Function, Function<Oas30Parameter, T> oas30Function) {
        if (parameter instanceof Oas20Parameter) {
            Oas20Parameter oas20Parameter = (Oas20Parameter)parameter;
            return oas20Function.apply(oas20Parameter);
        }
        if (parameter instanceof Oas30Parameter) {
            Oas30Parameter oas30Parameter = (Oas30Parameter)parameter;
            return oas30Function.apply(oas30Parameter);
        }
        throw new IllegalArgumentException(String.format("Unsupported operation parameter type: %s", parameter.getClass()));
    }

    private static <T> T delegate(OasSchema schema, Function<Oas20Schema, T> oas20Function, Function<Oas30Schema, T> oas30Function) {
        if (schema instanceof Oas20Schema) {
            Oas20Schema oas20Schema = (Oas20Schema)schema;
            return oas20Function.apply(oas20Schema);
        }
        if (schema instanceof Oas30Schema) {
            Oas30Schema oas30Schema = (Oas30Schema)schema;
            return oas30Function.apply(oas30Schema);
        }
        throw new IllegalArgumentException(String.format("Unsupported operation parameter type: %s", schema.getClass()));
    }

    private static <T> T delegate(OasOperation operation, Function<Oas20Operation, T> oas20Function, Function<Oas30Operation, T> oas30Function) {
        if (operation instanceof Oas20Operation) {
            Oas20Operation oas20Operation = (Oas20Operation)operation;
            return oas20Function.apply(oas20Operation);
        }
        if (operation instanceof Oas30Operation) {
            Oas30Operation oas30Operation = (Oas30Operation)operation;
            return oas30Function.apply(oas30Operation);
        }
        throw new IllegalArgumentException(String.format("Unsupported operation type: %s", operation.getClass()));
    }

    private static <T> T delegate(OasDocument openApiDoc, OasOperation operation, BiFunction<Oas20Document, Oas20Operation, T> oas20Function, BiFunction<Oas30Document, Oas30Operation, T> oas30Function) {
        if (OasModelHelper.isOas20(openApiDoc)) {
            return oas20Function.apply((Oas20Document)openApiDoc, (Oas20Operation)operation);
        }
        if (OasModelHelper.isOas30(openApiDoc)) {
            return oas30Function.apply((Oas30Document)openApiDoc, (Oas30Operation)operation);
        }
        throw new IllegalArgumentException(String.format("Unsupported Open API document type: %s", openApiDoc.getClass()));
    }

    private static boolean isOas30(OasDocument openApiDoc) {
        return OpenApiVersion.fromDocumentType(openApiDoc).equals((Object)OpenApiVersion.V3);
    }

    private static boolean isOas20(OasDocument openApiDoc) {
        return OpenApiVersion.fromDocumentType(openApiDoc).equals((Object)OpenApiVersion.V2);
    }

    private static Map<String, OasResponse> resolveResponses(OasDocument openApiDoc, OasResponses responses) {
        Function<String, OasResponse> responseResolver = OasModelHelper.getResponseResolver(openApiDoc);
        HashMap<String, OasResponse> responseMap = new HashMap<String, OasResponse>();
        for (OasResponse response : responses.getResponses()) {
            if (response.$ref != null) {
                OasResponse resolved = responseResolver.apply(OasModelHelper.getReferenceName(response.$ref));
                if (resolved == null) continue;
                responseMap.put(response.getStatusCode(), resolved);
                continue;
            }
            responseMap.put(response.getStatusCode(), response);
        }
        if (responses.default_ != null) {
            if (responses.default_.$ref != null) {
                OasResponse resolved = responseResolver.apply(responses.default_.$ref);
                if (resolved != null) {
                    responseMap.put(DEFAULT, resolved);
                }
            } else {
                responseMap.put(DEFAULT, responses.default_);
            }
        }
        return responseMap;
    }

    private static Function<String, OasResponse> getResponseResolver(OasDocument openApiDoc) {
        return OasModelHelper.delegate(openApiDoc, (Oas20Document doc) -> responseRef -> doc.responses.getResponse(OasModelHelper.getReferenceName(responseRef)), (Oas30Document doc) -> responseRef -> (OasResponse)doc.components.responses.get(OasModelHelper.getReferenceName(responseRef)));
    }

    public static void visitOasOperations(OasDocument oasDocument, final OasOperationVisitor visitor) {
        if (oasDocument == null || visitor == null || oasDocument.paths == null) {
            return;
        }
        oasDocument.paths.accept((IVisitor)new CombinedVisitorAdapter(){

            public void visitPaths(OasPaths oasPaths) {
                oasPaths.getPathItems().forEach(oasPathItem -> oasPathItem.accept((IVisitor)this));
            }

            public void visitPathItem(OasPathItem oasPathItem) {
                String path = oasPathItem.getPath();
                if (StringUtils.isEmpty((String)path)) {
                    return;
                }
                OasModelHelper.getOperationMap(oasPathItem).values().forEach(oasOperation -> visitor.visit(oasPathItem, (OasOperation)oasOperation));
            }
        });
    }

    public static List<String> resolveAllTypes(@Nullable List<String> acceptedMediaTypes) {
        if (acceptedMediaTypes == null) {
            return Collections.emptyList();
        }
        return acceptedMediaTypes.stream().flatMap(types -> Arrays.stream(types.split(","))).map(String::trim).toList();
    }

    public static String toJson(OasDocument openApiDoc) {
        Oas20Traverser oasTraverser;
        Oas20DataModelWriter writer;
        if (openApiDoc instanceof Oas20Document) {
            writer = new Oas20DataModelWriter();
            oasTraverser = new Oas20Traverser((IOas20Visitor)writer);
        } else if (openApiDoc instanceof Oas30Document) {
            writer = new Oas30DataModelWriter();
            oasTraverser = new Oas30Traverser((IOas30Visitor)writer);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported Open API document type: %s", openApiDoc.getClass()));
        }
        oasTraverser.traverse((Node)openApiDoc);
        return writer.getResult().toString();
    }

    public static List<String> toAcceptedRandomizableMediaTypes(String accept) {
        ArrayList<String> acceptedMediaTypesForRandomGeneration = new ArrayList<String>();
        if (StringUtils.hasText((String)accept)) {
            List<String> acceptedMediaTypes = OasModelHelper.resolveAllTypes(List.of(accept));
            acceptedMediaTypes.stream().filter(mediaType -> StringUtils.hasText((String)mediaType) && mediaType.contains("json")).forEach(acceptedMediaTypesForRandomGeneration::add);
            acceptedMediaTypes.stream().filter(mediaType -> StringUtils.hasText((String)mediaType) && mediaType.contains("text/plain")).forEach(acceptedMediaTypesForRandomGeneration::add);
        } else {
            acceptedMediaTypesForRandomGeneration.addAll(DEFAULT_ACCEPTED_MEDIA_TYPES);
        }
        return acceptedMediaTypesForRandomGeneration;
    }
}

