/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpServerResponseActionBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessageHeaderBuilder;
import org.citrusframework.message.builder.DefaultHeaderBuilder;
import org.citrusframework.openapi.AutoFillType;
import org.citrusframework.openapi.OpenApiMessageType;
import org.citrusframework.openapi.OpenApiSettings;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.OpenApiTestDataGenerator;
import org.citrusframework.openapi.actions.OpenApiSpecificationSource;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.openapi.model.OasAdapter;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.validation.OpenApiOperationToMessageHeadersProcessor;
import org.citrusframework.openapi.validation.OpenApiValidationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public class OpenApiServerResponseActionBuilder
extends HttpServerResponseActionBuilder
implements OpenApiSpecificationSourceAwareBuilder<SendMessageAction> {
    private final OpenApiSpecificationSource openApiSpecificationSource;
    private final String operationKey;
    private OpenApiOperationToMessageHeadersProcessor openApiOperationToMessageHeadersProcessor;
    private boolean schemaValidation = true;

    public OpenApiServerResponseActionBuilder(OpenApiSpecificationSource openApiSpecificationSource, String operationKey, String statusCode, String accept) {
        this(new HttpMessage(), openApiSpecificationSource, operationKey, statusCode, accept);
    }

    public OpenApiServerResponseActionBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpecificationSource, String operationKey, String statusCode, String accept) {
        super((MessageBuilder)new OpenApiServerResponseMessageBuilder(httpMessage, openApiSpecificationSource, operationKey, statusCode, accept), httpMessage);
        this.openApiSpecificationSource = openApiSpecificationSource;
        this.operationKey = operationKey;
    }

    @Override
    public OpenApiSpecificationSource getOpenApiSpecificationSource() {
        return this.openApiSpecificationSource;
    }

    public OpenApiServerResponseActionBuilder autoFill(AutoFillType autoFill) {
        ((OpenApiServerResponseMessageBuilder)((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder()).autoFill(autoFill);
        return this;
    }

    public SendMessageAction doBuild() {
        OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(this.referenceResolver);
        OpenApiValidationContext openApiValidationContext = openApiSpecification.getOpenApiValidationContext();
        if (openApiValidationContext != null && this.schemaValidation) {
            this.schemaValidation = openApiValidationContext.isResponseValidationEnabled();
        }
        if (this.schemaValidation && !this.messageProcessors.contains(this.openApiOperationToMessageHeadersProcessor)) {
            this.openApiOperationToMessageHeadersProcessor = new OpenApiOperationToMessageHeadersProcessor(openApiSpecification, this.operationKey, OpenApiMessageType.RESPONSE);
            this.process(this.openApiOperationToMessageHeadersProcessor);
        }
        return super.doBuild();
    }

    public OpenApiServerResponseActionBuilder schemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
        return this;
    }

    protected HttpServerResponseActionBuilder.HttpMessageBuilderSupport createMessageBuilderSupport() {
        HttpServerResponseActionBuilder.HttpMessageBuilderSupport messageBuilderSupport = super.createMessageBuilderSupport();
        messageBuilderSupport.schemaValidation(true);
        return messageBuilderSupport;
    }

    public OpenApiServerResponseActionBuilder enableRandomGeneration(AutoFillType autoFillType) {
        ((OpenApiServerResponseMessageBuilder)this.getMessageBuilderSupport().getMessageBuilder()).autoFill(autoFillType);
        return this;
    }

    private static class OpenApiServerResponseMessageBuilder
    extends HttpMessageBuilder {
        private static final Pattern STATUS_CODE_PATTERN = Pattern.compile("\\d+");
        private final OpenApiSpecificationSource openApiSpecificationSource;
        private final String operationKey;
        private final String statusCode;
        private final String accept;
        private AutoFillType autoFill;

        public OpenApiServerResponseMessageBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpecificationSource, String operationKey, String statusCode, String accept) {
            super(httpMessage);
            this.openApiSpecificationSource = openApiSpecificationSource;
            this.operationKey = operationKey;
            this.statusCode = statusCode;
            this.accept = accept;
        }

        public OpenApiServerResponseMessageBuilder autoFill(AutoFillType autoFillType) {
            this.autoFill = autoFillType;
            return this;
        }

        public Message build(TestContext context, String messageType) {
            OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(context.getReferenceResolver());
            if (this.autoFill == null) {
                this.autoFill = OpenApiSettings.getResponseAutoFillRandomValues();
            }
            if (STATUS_CODE_PATTERN.matcher(this.statusCode).matches()) {
                this.getMessage().status((HttpStatusCode)HttpStatus.valueOf((int)Integer.parseInt(this.statusCode)));
            } else {
                this.getMessage().status((HttpStatusCode)HttpStatus.OK);
            }
            ArrayList initialHeaderBuilders = new ArrayList(this.getHeaderBuilders());
            this.getHeaderBuilders().clear();
            openApiSpecification.getOperation(this.operationKey, context).ifPresentOrElse(operationPathAdapter -> this.fillRandomData(openApiSpecification, (OperationPathAdapter)operationPathAdapter, context), () -> {
                throw new CitrusRuntimeException("Unable to locate operation with id '%s' in OpenAPI specification %s".formatted(this.operationKey, openApiSpecification.getSpecUrl()));
            });
            this.getHeaderBuilders().addAll(initialHeaderBuilders);
            return super.build(context, messageType);
        }

        private void fillRandomData(OpenApiSpecification openApiSpecification, OperationPathAdapter operationPathAdapter, TestContext context) {
            if (operationPathAdapter.operation().responses != null) {
                this.buildResponse(context, openApiSpecification, operationPathAdapter.operation());
            }
        }

        private void buildResponse(TestContext context, OpenApiSpecification openApiSpecification, OasOperation operation) {
            OasDocument oasDocument = openApiSpecification.getOpenApiDoc(context);
            Optional<OasResponse> responseForRandomGeneration = OasModelHelper.getResponseForRandomGeneration(oasDocument, operation, this.statusCode, null);
            if (responseForRandomGeneration.isPresent()) {
                OasResponse oasResponse = responseForRandomGeneration.get();
                if (this.autoFill != AutoFillType.NONE) {
                    this.buildRandomHeaders(context, openApiSpecification, oasResponse);
                    this.buildRandomPayload(openApiSpecification, operation, oasResponse);
                }
                Map<String, OasSchema> headers = OasModelHelper.getHeaders(oasDocument, oasResponse);
                headers.entrySet().stream().filter(entry -> context.getVariables().containsKey(entry.getKey())).forEach(entry -> this.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(Collections.singletonMap((String)entry.getKey(), "${" + (String)entry.getKey() + "}"))));
            }
        }

        private void buildRandomHeaders(TestContext context, OpenApiSpecification openApiSpecification, OasResponse response) {
            if (this.autoFill == AutoFillType.NONE) {
                return;
            }
            HashSet filteredHeaders = new HashSet(this.getMessage().getHeaders().keySet());
            Predicate<Map.Entry> filteredHeadersPredicate = entry -> !filteredHeaders.contains(entry.getKey());
            OasDocument oasDocument = openApiSpecification.getOpenApiDoc(context);
            Map<String, OasSchema> headersToFill = this.autoFill == AutoFillType.REQUIRED ? OasModelHelper.getRequiredHeaders(oasDocument, response) : OasModelHelper.getHeaders(oasDocument, response);
            headersToFill.entrySet().stream().filter(filteredHeadersPredicate).forEach(entry -> this.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(Collections.singletonMap((String)entry.getKey(), OpenApiTestDataGenerator.createRandomValueExpression((String)entry.getKey(), (OasSchema)entry.getValue(), openApiSpecification, context)))));
        }

        private void buildRandomPayload(OpenApiSpecification openApiSpecification, OasOperation operation, OasResponse response) {
            Optional<OasAdapter<OasSchema, String>> schemaForMediaTypeOptional = this.statusCode.startsWith("2") ? OasModelHelper.getRandomizableSchema(operation, response, this.accept) : OasModelHelper.getRandomizableSchema(operation, response, null);
            if (schemaForMediaTypeOptional.isPresent()) {
                String string;
                Object object;
                OasAdapter<OasSchema, String> schemaForMediaType = schemaForMediaTypeOptional.get();
                if (this.getMessage().getPayload() == null || (object = this.getMessage().getPayload()) instanceof String && (string = (String)object).isEmpty()) {
                    this.createRandomPayload(this.getMessage(), openApiSpecification, schemaForMediaType);
                }
                if (!this.getMessage().getHeaders().containsKey("Content-Type") && schemaForMediaType.adapted() != null && schemaForMediaType.node() != null) {
                    this.addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(Collections.singletonMap("Content-Type", schemaForMediaType.adapted())));
                }
            }
        }

        private void createRandomPayload(HttpMessage message, OpenApiSpecification openApiSpecification, OasAdapter<OasSchema, String> schemaForMediaType) {
            if (schemaForMediaType.node() == null) {
                message.setPayload(null);
            } else {
                String mediaTypeName = schemaForMediaType.adapted();
                if ("application/json".equals(mediaTypeName) || "application/json;charset=UTF-8".equals(mediaTypeName)) {
                    message.setPayload((Object)OpenApiTestDataGenerator.createOutboundPayload(schemaForMediaType.node(), openApiSpecification));
                    message.setHeader("Content-Type", (Object)mediaTypeName);
                } else if ("text/plain".equals(schemaForMediaType.adapted())) {
                    message.setPayload((Object)OpenApiTestDataGenerator.createOutboundPayload(schemaForMediaType.node(), openApiSpecification));
                    message.setHeader("Content-Type", (Object)"text/plain");
                }
            }
        }
    }
}

