/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import org.citrusframework.CitrusSettings;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.http.actions.HttpServerRequestActionBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessageType;
import org.citrusframework.openapi.OpenApiMessageType;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.actions.OpenApiSpecificationSource;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.openapi.validation.OpenApiMessageValidationContext;
import org.citrusframework.openapi.validation.OpenApiOperationToMessageHeadersProcessor;
import org.citrusframework.openapi.validation.OpenApiValidationContext;
import org.citrusframework.validation.context.ValidationContext;

public class OpenApiServerRequestActionBuilder
extends HttpServerRequestActionBuilder
implements OpenApiSpecificationSourceAwareBuilder<ReceiveMessageAction> {
    private final OpenApiSpecificationSource openApiSpecificationSource;
    private final String operationKey;
    private OpenApiOperationToMessageHeadersProcessor openApiOperationToMessageHeadersProcessor;
    private boolean schemaValidation = true;

    public OpenApiServerRequestActionBuilder(OpenApiSpecificationSource openApiSpecificationSource, String operationKey) {
        this(new HttpMessage(), openApiSpecificationSource, operationKey);
    }

    public OpenApiServerRequestActionBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpecificationSource, String operationKey) {
        super((MessageBuilder)new OpenApiServerRequestMessageBuilder(httpMessage, openApiSpecificationSource), httpMessage);
        this.openApiSpecificationSource = openApiSpecificationSource;
        this.operationKey = operationKey;
    }

    @Override
    public OpenApiSpecificationSource getOpenApiSpecificationSource() {
        return this.openApiSpecificationSource;
    }

    protected void reconcileValidationContexts() {
        super.reconcileValidationContexts();
        OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(this.referenceResolver);
        if (this.getValidationContexts().stream().noneMatch(OpenApiMessageValidationContext.class::isInstance)) {
            this.validate((ValidationContext)OpenApiMessageValidationContext.Builder.openApi(openApiSpecification).schemaValidation(this.schemaValidation).build());
        }
    }

    protected HttpServerRequestActionBuilder.HttpMessageBuilderSupport createMessageBuilderSupport() {
        HttpServerRequestActionBuilder.HttpMessageBuilderSupport support = super.createMessageBuilderSupport();
        support.type(CitrusSettings.getPropertyEnvOrDefault((String)"citrus.default.message.type", (String)"CITRUS_DEFAULT_MESSAGE_TYPE", (String)MessageType.JSON.toString()));
        return support;
    }

    public ReceiveMessageAction doBuild() {
        OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(this.referenceResolver);
        OpenApiValidationContext openApiValidationContext = openApiSpecification.getOpenApiValidationContext();
        if (openApiValidationContext != null && this.schemaValidation) {
            this.schemaValidation = openApiValidationContext.isRequestValidationEnabled();
        }
        if (!this.messageProcessors.contains(this.openApiOperationToMessageHeadersProcessor)) {
            this.openApiOperationToMessageHeadersProcessor = new OpenApiOperationToMessageHeadersProcessor(openApiSpecification, this.operationKey, OpenApiMessageType.REQUEST);
            this.process(this.openApiOperationToMessageHeadersProcessor);
        }
        return super.doBuild();
    }

    public OpenApiServerRequestActionBuilder schemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
        return this;
    }

    private static class OpenApiServerRequestMessageBuilder
    extends HttpMessageBuilder {
        private final OpenApiSpecificationSource openApiSpecificationSource;

        public OpenApiServerRequestMessageBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpecificationSource) {
            super(httpMessage);
            this.openApiSpecificationSource = openApiSpecificationSource;
        }

        public Message build(TestContext context, String messageType) {
            OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(context.getReferenceResolver());
            context.setVariable(openApiSpecification.getUid(), (Object)openApiSpecification);
            return super.build(context, messageType);
        }
    }
}

