/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import org.citrusframework.TestAction;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.openapi.actions.OpenApiServerRequestActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerResponseActionBuilder;
import org.citrusframework.openapi.actions.OpenApiSpecificationSource;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.spi.AbstractReferenceResolverAwareTestActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.ObjectHelper;
import org.springframework.http.HttpStatus;

public class OpenApiServerActionBuilder
extends AbstractReferenceResolverAwareTestActionBuilder<TestAction>
implements OpenApiSpecificationSourceAwareBuilder<TestAction> {
    private final OpenApiSpecificationSource openApiSpecificationSource;
    private Endpoint httpServer;
    private String httpServerUri;

    public OpenApiServerActionBuilder(Endpoint httpServer, OpenApiSpecificationSource specification) {
        this.httpServer = httpServer;
        this.openApiSpecificationSource = specification;
    }

    public OpenApiServerActionBuilder(String httpServerUri, OpenApiSpecificationSource specification) {
        this.httpServerUri = httpServerUri;
        this.openApiSpecificationSource = specification;
    }

    @Override
    public OpenApiSpecificationSource getOpenApiSpecificationSource() {
        return this.openApiSpecificationSource;
    }

    public OpenApiServerRequestActionBuilder receive(String operationKey) {
        OpenApiServerRequestActionBuilder builder = new OpenApiServerRequestActionBuilder(this.openApiSpecificationSource, operationKey);
        if (this.httpServer != null) {
            builder.endpoint(this.httpServer);
        } else {
            builder.endpoint(this.httpServerUri);
        }
        builder.name("openapi:receive-request");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public OpenApiServerResponseActionBuilder send(String operationKey) {
        return this.send(operationKey, HttpStatus.OK);
    }

    public OpenApiServerResponseActionBuilder send(String operationKey, HttpStatus status) {
        return this.send(operationKey, String.valueOf(status.value()));
    }

    public OpenApiServerResponseActionBuilder send(String operationKey, HttpStatus status, String accept) {
        return this.send(operationKey, String.valueOf(status.value()), accept);
    }

    public OpenApiServerResponseActionBuilder send(String operationKey, String statusCode) {
        return this.send(operationKey, statusCode, null);
    }

    public OpenApiServerResponseActionBuilder send(String operationKey, String statusCode, String accept) {
        OpenApiServerResponseActionBuilder builder = new OpenApiServerResponseActionBuilder(this.openApiSpecificationSource, operationKey, statusCode, accept);
        if (this.httpServer != null) {
            builder.endpoint(this.httpServer);
        } else {
            builder.endpoint(this.httpServerUri);
        }
        builder.name("openapi:send-response");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public OpenApiServerActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull((Object)this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }
}

