/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.openapi.AutoFillType;
import org.citrusframework.openapi.OpenApiMessageType;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.OpenApiTestDataGenerator;
import org.citrusframework.openapi.actions.OpenApiPayloadBuilder;
import org.citrusframework.openapi.actions.OpenApiSpecificationSource;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.openapi.model.OperationPathAdapter;
import org.citrusframework.openapi.validation.OpenApiOperationToMessageHeadersProcessor;
import org.citrusframework.openapi.validation.OpenApiValidationContext;
import org.citrusframework.util.StringUtils;
import org.springframework.http.HttpMethod;

public class OpenApiClientRequestActionBuilder
extends HttpClientRequestActionBuilder
implements OpenApiSpecificationSourceAwareBuilder<SendMessageAction> {
    private final OpenApiSpecificationSource openApiSpecificationSource;
    private final String operationKey;
    private OpenApiOperationToMessageHeadersProcessor openApiOperationToMessageHeadersProcessor;
    private boolean schemaValidation = true;

    public OpenApiClientRequestActionBuilder(OpenApiSpecificationSource openApiSpec, String operationKey) {
        this(new HttpMessage(), openApiSpec, operationKey);
    }

    public OpenApiClientRequestActionBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpec, String operationKey) {
        this(openApiSpec, new OpenApiClientRequestMessageBuilder(httpMessage, openApiSpec, operationKey), httpMessage, operationKey);
    }

    public OpenApiClientRequestActionBuilder(OpenApiSpecificationSource openApiSpec, OpenApiClientRequestMessageBuilder messageBuilder, HttpMessage message, String operationKey) {
        super((MessageBuilder)messageBuilder, message);
        this.openApiSpecificationSource = openApiSpec;
        this.operationKey = operationKey;
    }

    @Override
    public OpenApiSpecificationSource getOpenApiSpecificationSource() {
        return this.openApiSpecificationSource;
    }

    public OpenApiClientRequestActionBuilder autoFill(AutoFillType autoFill) {
        ((OpenApiClientRequestMessageBuilder)((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)this.messageBuilderSupport).getMessageBuilder()).autoFill(autoFill);
        return this;
    }

    public SendMessageAction doBuild() {
        OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(this.referenceResolver);
        OpenApiValidationContext openApiValidationContext = openApiSpecification.getOpenApiValidationContext();
        if (openApiValidationContext != null && this.schemaValidation) {
            this.schemaValidation = openApiValidationContext.isRequestValidationEnabled();
        }
        if (this.schemaValidation && !this.messageProcessors.contains(this.openApiOperationToMessageHeadersProcessor)) {
            this.openApiOperationToMessageHeadersProcessor = new OpenApiOperationToMessageHeadersProcessor(openApiSpecification, this.operationKey, OpenApiMessageType.REQUEST);
            this.process(this.openApiOperationToMessageHeadersProcessor);
        }
        return super.doBuild();
    }

    protected HttpClientRequestActionBuilder.HttpMessageBuilderSupport createHttpMessageBuilderSupport() {
        HttpClientRequestActionBuilder.HttpMessageBuilderSupport httpMessageBuilderSupport = super.createHttpMessageBuilderSupport();
        httpMessageBuilderSupport.schemaValidation(true);
        return httpMessageBuilderSupport;
    }

    public OpenApiClientRequestActionBuilder schemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
        return this;
    }

    public static class OpenApiClientRequestMessageBuilder
    extends HttpMessageBuilder {
        private final OpenApiSpecificationSource openApiSpecificationSource;
        private final String operationKey;
        private AutoFillType autoFill;

        public OpenApiClientRequestMessageBuilder(HttpMessage httpMessage, OpenApiSpecificationSource openApiSpec, String operationKey) {
            super(httpMessage);
            this.openApiSpecificationSource = openApiSpec;
            this.operationKey = operationKey;
        }

        public OpenApiClientRequestMessageBuilder autoFill(AutoFillType autoFill) {
            this.autoFill = autoFill;
            return this;
        }

        public Message build(TestContext context, String messageType) {
            OpenApiSpecification openApiSpecification = this.openApiSpecificationSource.resolve(context.getReferenceResolver());
            if (this.autoFill == null) {
                this.autoFill = openApiSpecification.getRequestAutoFill();
            }
            openApiSpecification.initOpenApiDoc(context);
            openApiSpecification.getOperation(this.operationKey, context).ifPresentOrElse(operationPathAdapter -> this.buildMessageFromOperation(openApiSpecification, (OperationPathAdapter)operationPathAdapter, context), () -> {
                throw new CitrusRuntimeException("Unable to locate operation with id '%s' in OpenAPI specification %s".formatted(this.operationKey, openApiSpecification.getSpecUrl()));
            });
            context.setVariable(openApiSpecification.getUid(), (Object)openApiSpecification);
            return super.build(context, messageType);
        }

        public Object buildMessagePayload(TestContext context, String messageType) {
            if (this.getPayloadBuilder() == null) {
                this.setPayloadBuilder((MessagePayloadBuilder)new OpenApiPayloadBuilder(this.getMessage().getPayload()));
            }
            return super.buildMessagePayload(context, messageType);
        }

        private void buildMessageFromOperation(OpenApiSpecification openApiSpecification, OperationPathAdapter operationPathAdapter, TestContext context) {
            String randomizedPath;
            OasOperation operation = operationPathAdapter.operation();
            String path = operationPathAdapter.fullPath();
            HttpMethod method = HttpMethod.valueOf((String)operationPathAdapter.operation().getMethod().toUpperCase(Locale.US));
            if (operation.parameters != null) {
                this.setMissingHeadersToRandomValues(openApiSpecification, context, operation);
                this.setMissingQueryParametersToRandomValues(openApiSpecification, context, operation);
            }
            this.setMissingBodyToRandomValue(openApiSpecification, context, operation);
            String string = randomizedPath = this.getMessage().getPath() != null ? this.getMessage().getPath() : path;
            if (operation.parameters != null) {
                List<OasParameter> pathParams = operation.parameters.stream().filter(p -> "path".equals(p.in)).toList();
                for (OasParameter parameter : pathParams) {
                    String pathParameterValue = this.getDefinedPathParameter(context, parameter.getName());
                    Object parameterValue = StringUtils.isNotEmpty((String)pathParameterValue) ? "\\" + pathParameterValue : OpenApiTestDataGenerator.createRandomValueExpression((OasSchema)parameter.schema);
                    randomizedPath = randomizedPath.replaceAll("\\{" + parameter.getName() + "}", (String)parameterValue);
                }
            }
            OasModelHelper.getRequestContentType(operation).ifPresent(contentType -> this.getMessage().setHeader("Content-Type", contentType));
            this.getMessage().path(randomizedPath);
            this.getMessage().method(method);
        }

        protected String getDefinedPathParameter(TestContext context, String name) {
            if (context.getVariables().containsKey(name)) {
                return "${" + name + "}";
            }
            return null;
        }

        private void setMissingBodyToRandomValue(OpenApiSpecification openApiSpecification, TestContext context, OasOperation operation) {
            String payloadString;
            Object object;
            if (this.getMessage().getPayload() == null || (object = this.getMessage().getPayload()) instanceof String && (payloadString = (String)object).isEmpty()) {
                Optional<OasSchema> body = OasModelHelper.getRequestBodySchema(openApiSpecification.getOpenApiDoc(context), operation);
                body.ifPresent(oasSchema -> {
                    if (this.autoFill.shouldFill(OasModelHelper.isOperationRequestBodyRequired(openApiSpecification.getOpenApiDoc(context), operation))) {
                        this.getMessage().setPayload((Object)OpenApiTestDataGenerator.createOutboundPayload(oasSchema, openApiSpecification));
                    }
                });
            }
        }

        private void setMissingQueryParametersToRandomValues(OpenApiSpecification openApiSpecification, TestContext context, OasOperation operation) {
            operation.parameters.stream().filter(param -> "query".equals(param.in)).filter(param -> !this.getMessage().getQueryParams().containsKey(param.getName())).filter(param -> this.autoFill.shouldFill(param.required)).forEach(param -> {
                Object queryParameterValue = context.getVariables().get(param.getName());
                if (queryParameterValue == null) {
                    queryParameterValue = OpenApiTestDataGenerator.createRandomValueExpression(param.getName(), (OasSchema)param.schema, openApiSpecification, context);
                }
                try {
                    this.getMessage().queryParam(param.getName(), queryParameterValue.toString());
                }
                catch (Exception e) {
                    TestActionBuilder.logger.warn("Unable to set missing required query parameter to random value: {}", param);
                }
            });
        }

        private void setMissingHeadersToRandomValues(OpenApiSpecification openApiSpecification, TestContext context, OasOperation operation) {
            List configuredHeaders = this.getHeaderBuilders().stream().flatMap(b -> b.builderHeaders(context).keySet().stream()).toList();
            operation.parameters.stream().filter(param -> "header".equals(param.in)).filter(param -> this.getMessage().getHeader(param.getName()) == null && !configuredHeaders.contains(param.getName())).filter(param -> this.autoFill.shouldFill(param.required)).forEach(param -> {
                Object headerValue = context.getVariables().get(param.getName());
                if (headerValue == null) {
                    headerValue = OpenApiTestDataGenerator.createRandomValueExpression(param.getName(), (OasSchema)param.schema, openApiSpecification, context);
                }
                this.getMessage().setHeader(param.getName(), headerValue);
            });
        }
    }
}

