/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import java.net.URL;
import org.citrusframework.TestAction;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.openapi.OpenApiSettings;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.actions.OpenApiClientActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerActionBuilder;
import org.citrusframework.openapi.actions.OpenApiSpecificationSource;
import org.citrusframework.openapi.actions.OpenApiSpecificationSourceAwareBuilder;
import org.citrusframework.spi.AbstractReferenceResolverAwareTestActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.ObjectHelper;

public class OpenApiActionBuilder
extends AbstractReferenceResolverAwareTestActionBuilder<TestAction>
implements OpenApiSpecificationSourceAwareBuilder<TestAction> {
    private OpenApiSpecificationSource openApiSpecificationSource;

    public OpenApiActionBuilder() {
    }

    public OpenApiActionBuilder(OpenApiSpecification specification) {
        this.openApiSpecificationSource = new OpenApiSpecificationSource(specification);
    }

    public OpenApiActionBuilder(String openApiAlias) {
        this.openApiSpecificationSource = new OpenApiSpecificationSource(openApiAlias);
    }

    @Override
    public OpenApiSpecificationSource getOpenApiSpecificationSource() {
        return this.openApiSpecificationSource;
    }

    public static OpenApiActionBuilder openapi() {
        return new OpenApiActionBuilder();
    }

    public static OpenApiActionBuilder openapi(OpenApiSpecification specification) {
        return new OpenApiActionBuilder(specification);
    }

    public static OpenApiActionBuilder openapi(String openApiAlias) {
        return new OpenApiActionBuilder(openApiAlias);
    }

    public OpenApiActionBuilder specification(OpenApiSpecification specification) {
        this.openApiSpecificationSource = new OpenApiSpecificationSource(specification);
        return this;
    }

    public OpenApiActionBuilder specification(URL specUrl) {
        return this.specification(OpenApiSpecification.from(specUrl, OpenApiSettings.getOpenApiValidationPolicy()));
    }

    public OpenApiActionBuilder specification(String specUrl) {
        return this.specification(OpenApiSpecification.from(specUrl, OpenApiSettings.getOpenApiValidationPolicy()));
    }

    public OpenApiClientActionBuilder client() {
        this.assertSpecification();
        OpenApiClientActionBuilder clientActionBuilder = new OpenApiClientActionBuilder(this.openApiSpecificationSource).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public OpenApiClientActionBuilder client(HttpClient httpClient) {
        this.assertSpecification();
        if (httpClient.getEndpointConfiguration().getRequestUrl() != null) {
            this.openApiSpecificationSource.setHttpClient(httpClient.getEndpointConfiguration().getRequestUrl());
        }
        OpenApiClientActionBuilder clientActionBuilder = new OpenApiClientActionBuilder((Endpoint)httpClient, this.openApiSpecificationSource).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public OpenApiClientActionBuilder client(String httpClient) {
        this.assertSpecification();
        this.openApiSpecificationSource.setHttpClient(httpClient);
        OpenApiClientActionBuilder clientActionBuilder = new OpenApiClientActionBuilder(httpClient, this.openApiSpecificationSource).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public OpenApiServerActionBuilder server(Endpoint endpoint) {
        this.assertSpecification();
        OpenApiServerActionBuilder serverActionBuilder = new OpenApiServerActionBuilder(endpoint, this.openApiSpecificationSource).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    private void assertSpecification() {
        if (this.openApiSpecificationSource == null) {
            throw new CitrusRuntimeException("Invalid OpenApiSpecificationSource - please set specification first");
        }
    }

    public OpenApiServerActionBuilder server(String httpServer) {
        this.assertSpecification();
        OpenApiServerActionBuilder serverActionBuilder = new OpenApiServerActionBuilder(httpServer, this.openApiSpecificationSource).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    public OpenApiActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull((Object)this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }
}

