/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.openapi.OpenApiSettings;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.OpenApiSpecificationProcessor;
import org.citrusframework.openapi.validation.OpenApiValidationPolicy;
import org.citrusframework.repository.BaseRepository;
import org.citrusframework.spi.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiRepository
extends BaseRepository {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiRepository.class);
    private static final String DEFAULT_NAME = "openApiSchemaRepository";
    private final List<OpenApiSpecification> openApiSpecifications = Collections.synchronizedList(new ArrayList());
    private String rootContextPath;
    private boolean neglectBasePath = OpenApiSettings.isNeglectBasePathEnabled();
    private boolean requestValidationEnabled = OpenApiSettings.isRequestValidationEnabled();
    private boolean responseValidationEnabled = OpenApiSettings.isResponseValidationEnabled();
    private OpenApiValidationPolicy validationPolicy = OpenApiSettings.getOpenApiValidationPolicy();

    public OpenApiRepository() {
        super(DEFAULT_NAME);
    }

    public List<OpenApiSpecification> getOpenApiSpecifications() {
        return this.openApiSpecifications;
    }

    public String getRootContextPath() {
        return this.rootContextPath;
    }

    public void setRootContextPath(String rootContextPath) {
        this.rootContextPath = rootContextPath;
    }

    public OpenApiRepository rootContextPath(String rootContextPath) {
        this.setRootContextPath(rootContextPath);
        return this;
    }

    public boolean isNeglectBasePath() {
        return this.neglectBasePath;
    }

    public void setNeglectBasePath(boolean neglectBasePath) {
        this.neglectBasePath = neglectBasePath;
    }

    public OpenApiRepository neglectBasePath(boolean neglectBasePath) {
        this.setNeglectBasePath(neglectBasePath);
        return this;
    }

    public boolean isRequestValidationEnabled() {
        return this.requestValidationEnabled;
    }

    public void setRequestValidationEnabled(boolean requestValidationEnabled) {
        this.requestValidationEnabled = requestValidationEnabled;
    }

    public OpenApiRepository requestValidationEnabled(boolean requestValidationEnabled) {
        this.setRequestValidationEnabled(requestValidationEnabled);
        return this;
    }

    public boolean isResponseValidationEnabled() {
        return this.responseValidationEnabled;
    }

    public void setResponseValidationEnabled(boolean responseValidationEnabled) {
        this.responseValidationEnabled = responseValidationEnabled;
    }

    public OpenApiRepository responseValidationEnabled(boolean responseValidationEnabled) {
        this.setResponseValidationEnabled(responseValidationEnabled);
        return this;
    }

    public OpenApiValidationPolicy getValidationPolicy() {
        return this.validationPolicy;
    }

    public void setValidationPolicy(OpenApiValidationPolicy validationPolicy) {
        this.validationPolicy = validationPolicy;
    }

    public OpenApiRepository validationPolicy(OpenApiValidationPolicy openApiValidationPolicy) {
        this.setValidationPolicy(openApiValidationPolicy);
        return this;
    }

    public void addRepository(Resource openApiResource) {
        try {
            OpenApiSpecification openApiSpecification = OpenApiSpecification.from(openApiResource, this.validationPolicy);
            openApiSpecification.setApiRequestValidationEnabled(this.requestValidationEnabled);
            openApiSpecification.setApiResponseValidationEnabled(this.responseValidationEnabled);
            openApiSpecification.setRootContextPath(this.rootContextPath);
            openApiSpecification.neglectBasePath(this.neglectBasePath);
            this.addRepository(openApiSpecification);
        }
        catch (Exception e) {
            logger.error("Unable to read OpenApiSpecification from location: {}", (Object)openApiResource.getURI());
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public void addRepository(OpenApiSpecification openApiSpecification) {
        this.openApiSpecifications.add(openApiSpecification);
        OpenApiSpecificationProcessor.lookup().values().forEach(processor -> processor.process(openApiSpecification));
    }

    public OpenApiRepository locations(List<String> locations) {
        this.setLocations(locations);
        return this;
    }

    @Nullable
    public OpenApiSpecification openApi(@NotNull String alias) {
        if (alias.equals(this.getName())) {
            if (this.openApiSpecifications.size() == 1) {
                return this.openApiSpecifications.get(0);
            }
            throw new IllegalArgumentException("The alias matches the repository name, but the repository contains multiple specifications. Matching a specification by repository name is only allowed if there is exactly one specification in the repository.");
        }
        return this.getOpenApiSpecifications().stream().filter(spec -> spec.getAliases().contains(alias)).findFirst().orElse(null);
    }
}

