/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.model;

import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import java.util.Arrays;

public enum OpenApiVersion {
    V2("2.0", Oas20Document.class),
    V3("3.0", Oas30Document.class);

    private final Class<? extends OasDocument> documentType;

    private OpenApiVersion(String majorVersion, Class<? extends OasDocument> documentType) {
        this.documentType = documentType;
    }

    static OpenApiVersion fromDocumentType(OasDocument model) {
        return Arrays.stream(OpenApiVersion.values()).filter(version -> version.documentType.isInstance(model)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable get OpenAPI version from given document type"));
    }
}

