/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import io.apicurio.datamodels.openapi.models.OasDocument;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.openapi.OpenApiResourceLoader;
import org.citrusframework.openapi.model.OasModelHelper;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;

public class OpenApiSpecification {
    private String specUrl;
    private String httpClient;
    private String requestUrl;
    private OasDocument openApiDoc;
    private boolean generateOptionalFields = true;
    private boolean validateOptionalFields = true;

    public static OpenApiSpecification from(String specUrl) {
        OpenApiSpecification specification = new OpenApiSpecification();
        specification.setSpecUrl(specUrl);
        return specification;
    }

    public static OpenApiSpecification from(URL specUrl) {
        OpenApiSpecification specification = new OpenApiSpecification();
        OasDocument openApiDoc = specUrl.getProtocol().startsWith("https") ? OpenApiResourceLoader.fromSecuredWebResource(specUrl) : OpenApiResourceLoader.fromWebResource(specUrl);
        specification.setSpecUrl(specUrl.toString());
        specification.setOpenApiDoc(openApiDoc);
        specification.setRequestUrl(String.format("%s://%s%s%s", specUrl.getProtocol(), specUrl.getHost(), specUrl.getPort() > 0 ? ":" + specUrl.getPort() : "", OasModelHelper.getBasePath(openApiDoc)));
        return specification;
    }

    public static OpenApiSpecification from(Resource resource) {
        OpenApiSpecification specification = new OpenApiSpecification();
        OasDocument openApiDoc = OpenApiResourceLoader.fromFile(resource);
        specification.setOpenApiDoc(openApiDoc);
        String schemeToUse = Optional.ofNullable(OasModelHelper.getSchemes(openApiDoc)).orElse(Collections.singletonList("http")).stream().filter(s -> s.equals("http") || s.equals("https")).findFirst().orElse("http");
        specification.setSpecUrl(resource.getLocation());
        specification.setRequestUrl(String.format("%s://%s%s", schemeToUse, OasModelHelper.getHost(openApiDoc), OasModelHelper.getBasePath(openApiDoc)));
        return specification;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OasDocument getOpenApiDoc(TestContext context) {
        if (this.openApiDoc != null) {
            return this.openApiDoc;
        }
        if (this.specUrl == null) return this.openApiDoc;
        Object resolvedSpecUrl = context.replaceDynamicContentInString(this.specUrl);
        if (((String)resolvedSpecUrl).startsWith("/")) {
            if (this.requestUrl != null) {
                resolvedSpecUrl = this.requestUrl.endsWith("/") ? this.requestUrl + ((String)resolvedSpecUrl).substring(1) : this.requestUrl + (String)resolvedSpecUrl;
            } else {
                if (this.httpClient == null || !context.getReferenceResolver().isResolvable(this.httpClient, HttpClient.class)) throw new CitrusRuntimeException("Failed to resolve OpenAPI spec URL from relative path %s - make sure to provide a proper base URL when using relative paths".formatted(resolvedSpecUrl));
                String baseUrl = ((HttpClient)context.getReferenceResolver().resolve(this.httpClient, HttpClient.class)).getEndpointConfiguration().getRequestUrl();
                resolvedSpecUrl = baseUrl.endsWith("/") ? baseUrl + ((String)resolvedSpecUrl).substring(1) : baseUrl + (String)resolvedSpecUrl;
            }
        }
        if (((String)resolvedSpecUrl).startsWith("http")) {
            try {
                URL specWebResource = new URL((String)resolvedSpecUrl);
                this.openApiDoc = ((String)resolvedSpecUrl).startsWith("https") ? OpenApiResourceLoader.fromSecuredWebResource(specWebResource) : OpenApiResourceLoader.fromWebResource(specWebResource);
                if (this.requestUrl != null) return this.openApiDoc;
                this.setRequestUrl(String.format("%s://%s%s%s", specWebResource.getProtocol(), specWebResource.getHost(), specWebResource.getPort() > 0 ? ":" + specWebResource.getPort() : "", OasModelHelper.getBasePath(this.openApiDoc)));
                return this.openApiDoc;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to retrieve Open API specification as web resource: " + this.specUrl, e);
            }
        } else {
            this.openApiDoc = OpenApiResourceLoader.fromFile(Resources.create((String)resolvedSpecUrl));
            if (this.requestUrl != null) return this.openApiDoc;
            String schemeToUse = Optional.ofNullable(OasModelHelper.getSchemes(this.openApiDoc)).orElse(Collections.singletonList("http")).stream().filter(s -> s.equals("http") || s.equals("https")).findFirst().orElse("http");
            this.setRequestUrl(String.format("%s://%s%s", schemeToUse, OasModelHelper.getHost(this.openApiDoc), OasModelHelper.getBasePath(this.openApiDoc)));
        }
        return this.openApiDoc;
    }

    public void setOpenApiDoc(OasDocument openApiDoc) {
        this.openApiDoc = openApiDoc;
    }

    public String getSpecUrl() {
        return this.specUrl;
    }

    public void setSpecUrl(String specUrl) {
        this.specUrl = specUrl;
    }

    public void setHttpClient(String httpClient) {
        this.httpClient = httpClient;
    }

    public String getHttpClient() {
        return this.httpClient;
    }

    public String getRequestUrl() {
        if (this.requestUrl == null) {
            return this.specUrl;
        }
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public boolean isGenerateOptionalFields() {
        return this.generateOptionalFields;
    }

    public void setGenerateOptionalFields(boolean generateOptionalFields) {
        this.generateOptionalFields = generateOptionalFields;
    }

    public boolean isValidateOptionalFields() {
        return this.validateOptionalFields;
    }

    public void setValidateOptionalFields(boolean validateOptionalFields) {
        this.validateOptionalFields = validateOptionalFields;
    }
}

