/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.mail.server;

import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.mail.client.MailEndpointConfiguration;
import org.citrusframework.mail.message.MailMessage;
import org.citrusframework.mail.message.MailMessageConverter;
import org.citrusframework.mail.model.AcceptResponse;
import org.citrusframework.mail.model.AttachmentPart;
import org.citrusframework.mail.model.BodyPart;
import org.citrusframework.mail.model.MailMarshaller;
import org.citrusframework.mail.model.MailRequest;
import org.citrusframework.mail.model.MailResponse;
import org.citrusframework.message.Message;
import org.citrusframework.server.AbstractServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.MimeMailMessage;

public class MailServer
extends AbstractServer {
    private static final Logger logger = LoggerFactory.getLogger(MailServer.class);
    private int port = 25;
    private MailMarshaller marshaller = new MailMarshaller();
    private MailMessageConverter messageConverter = new MailMessageConverter();
    private Session mailSession;
    private Properties javaMailProperties = new Properties();
    private boolean autoAccept = true;
    private boolean authRequired = true;
    private boolean splitMultipart = false;
    private final List<String> knownUsers = new ArrayList<String>();
    private GreenMail smtpServer;

    protected void startup() {
        if (Objects.isNull(this.smtpServer)) {
            this.smtpServer = new GreenMail(new ServerSetup(this.port, null, "smtp"));
        }
        if (!this.authRequired) {
            this.smtpServer.getManagers().getSmtpManager().getUserManager().setAuthRequired(false);
        } else {
            this.addKnownUsers(this.smtpServer.getManagers().getSmtpManager().getUserManager());
        }
        this.smtpServer.getManagers().getSmtpManager().getUserManager().setMessageDeliveryHandler((msg, mailAddress) -> {
            GreenMailUser user = this.smtpServer.getManagers().getUserManager().getUserByEmail(mailAddress.getEmail());
            if (null == user) {
                String login = mailAddress.getUser();
                String email = mailAddress.getEmail();
                String password = mailAddress.getEmail();
                user = this.smtpServer.getManagers().getUserManager().createUser(email, login, password);
            }
            if (!this.accept(msg.getReturnPath().getEmail(), msg.getToAddresses())) {
                throw new AuthenticationFailedException("Invalid user");
            }
            this.deliver(msg.getMessage());
            return user;
        });
        this.smtpServer.start();
    }

    private void addKnownUsers(UserManager userManager) {
        this.knownUsers.stream().map(userSpec -> userSpec.split(":")).map(credentials -> {
            if (((String[])credentials).length > 3) {
                return new String[]{credentials[0], credentials[1], credentials[2]};
            }
            if (((String[])credentials).length == 2) {
                return new String[]{credentials[0], credentials[1], credentials[0]};
            }
            if (((String[])credentials).length == 1) {
                return new String[]{credentials[0], credentials[0], credentials[0]};
            }
            return credentials;
        }).filter(credentials -> ((String[])credentials).length == 3).forEach(credentials -> {
            try {
                userManager.createUser(credentials[0], credentials[1], credentials[2]);
            }
            catch (UserException e) {
                logger.warn(String.format("Failed to create known user: %s:%s:%s", credentials[0], credentials[1], credentials[2]));
            }
        });
    }

    protected void shutdown() {
        this.smtpServer.stop();
    }

    public boolean accept(String from, List<MailAddress> recipients) {
        if (this.autoAccept) {
            return true;
        }
        Message response = this.getEndpointAdapter().handleMessage((Message)MailMessage.accept(from, recipients.stream().map(MailAddress::getEmail).collect(Collectors.joining(","))).marshaller(this.marshaller));
        if (response == null || response.getPayload() == null) {
            throw new CitrusRuntimeException("Did not receive accept response. Missing accept response because autoAccept is disabled.");
        }
        AcceptResponse acceptResponse = null;
        if (response.getPayload() instanceof AcceptResponse) {
            acceptResponse = (AcceptResponse)response.getPayload();
        } else if (response.getPayload() instanceof String) {
            acceptResponse = (AcceptResponse)this.marshaller.unmarshal((Source)response.getPayload(Source.class));
        }
        if (acceptResponse == null) {
            throw new CitrusRuntimeException("Unable to read accept response from payload: " + response);
        }
        return acceptResponse.isAccept();
    }

    public void deliver(MimeMessage mimeMessage) {
        MimeMailMessage mimeMailMessage = new MimeMailMessage(mimeMessage);
        MailMessage request = this.messageConverter.convertInbound(mimeMailMessage, this.getEndpointConfiguration(), null);
        Message response = this.invokeEndpointAdapter(request);
        if (response != null && response.getPayload() != null) {
            MailResponse mailResponse = null;
            if (response.getPayload() instanceof MailResponse) {
                mailResponse = (MailResponse)response.getPayload();
            } else if (response.getPayload() instanceof String) {
                mailResponse = (MailResponse)this.marshaller.unmarshal((Source)response.getPayload(Source.class));
            }
            if (mailResponse != null && mailResponse.getCode() != 250) {
                throw new CitrusRuntimeException(String.format("%s %s", mailResponse.getCode(), mailResponse.getMessage()));
            }
        }
    }

    protected Message invokeEndpointAdapter(MailMessage mail) {
        if (this.splitMultipart) {
            return this.split(mail.getPayload(MailRequest.class).getBody(), mail.getHeaders());
        }
        return this.getEndpointAdapter().handleMessage((Message)mail);
    }

    private Message split(BodyPart bodyPart, Map<String, Object> messageHeaders) {
        MailMessage mailRequest = this.messageConverter.createMailRequest(messageHeaders, new BodyPart(bodyPart.getContent(), bodyPart.getContentType()), this.marshaller);
        Stack<Message> responseStack = new Stack<Message>();
        if (bodyPart instanceof AttachmentPart) {
            this.fillStack(this.getEndpointAdapter().handleMessage((Message)mailRequest.setHeader("citrus_mail_content_type", bodyPart.getContentType()).setHeader("citrus_mail_filename", (Object)((AttachmentPart)bodyPart).getFileName())), responseStack);
        } else {
            this.fillStack(this.getEndpointAdapter().handleMessage((Message)mailRequest.setHeader("citrus_mail_content_type", bodyPart.getContentType())), responseStack);
        }
        if (bodyPart.hasAttachments()) {
            for (AttachmentPart attachmentPart : bodyPart.getAttachments().getAttachments()) {
                this.fillStack(this.split(attachmentPart, messageHeaders), responseStack);
            }
        }
        return responseStack.isEmpty() ? null : responseStack.pop();
    }

    private void fillStack(Message message, Stack<Message> responseStack) {
        if (message != null) {
            responseStack.push(message);
        }
    }

    public MailEndpointConfiguration getEndpointConfiguration() {
        MailEndpointConfiguration endpointConfiguration = new MailEndpointConfiguration();
        endpointConfiguration.setMessageConverter(this.messageConverter);
        endpointConfiguration.setMarshaller(this.marshaller);
        endpointConfiguration.setJavaMailProperties(this.javaMailProperties);
        return endpointConfiguration;
    }

    public synchronized Session getSession() {
        if (this.mailSession == null) {
            this.mailSession = Session.getInstance((Properties)this.javaMailProperties);
        }
        return this.mailSession;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public void setAuthRequired(boolean authRequired) {
        this.authRequired = authRequired;
    }

    public boolean isAutoAccept() {
        return this.autoAccept;
    }

    public void setAutoAccept(boolean autoAccept) {
        this.autoAccept = autoAccept;
    }

    public MailMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(MailMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public GreenMail getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(GreenMail smtpServer) {
        this.smtpServer = smtpServer;
    }

    public boolean isSplitMultipart() {
        return this.splitMultipart;
    }

    public void setSplitMultipart(boolean splitMultipart) {
        this.splitMultipart = splitMultipart;
    }

    public MailMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MailMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public List<String> getKnownUsers() {
        return this.knownUsers;
    }

    public void setKnownUsers(List<String> knownUsers) {
        this.knownUsers.addAll(knownUsers);
    }

    public void addKnownUser(String email, String login, String password) {
        this.knownUsers.add(String.join((CharSequence)":", email, login, password));
    }
}

