/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.mail.model;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.mail.MailSettings;
import org.citrusframework.mail.model.AcceptRequest;
import org.citrusframework.mail.model.AcceptResponse;
import org.citrusframework.mail.model.MailRequest;
import org.citrusframework.mail.model.MailResponse;
import org.citrusframework.message.MessageType;
import org.citrusframework.spi.Resources;
import org.citrusframework.xml.Jaxb2Marshaller;
import org.citrusframework.xml.Marshaller;
import org.citrusframework.xml.StringResult;
import org.citrusframework.xml.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailMarshaller
implements Marshaller,
Unmarshaller {
    private static final Logger logger = LoggerFactory.getLogger(MailMarshaller.class);
    private String type = MailSettings.getMarshallerType();
    private final ObjectMapper mapper;
    private final Jaxb2Marshaller marshaller;
    private final Class<?>[] classesToBeBound = new Class[]{AcceptRequest.class, AcceptResponse.class, MailRequest.class, MailResponse.class};

    public MailMarshaller() {
        this.mapper = new ObjectMapper();
        this.marshaller = new Jaxb2Marshaller(Resources.fromClasspath((String)"org/citrusframework/schema/citrus-mail-message.xsd"), (Class[])this.classesToBeBound);
    }

    public Object unmarshal(Source source) {
        if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                return this.marshaller.unmarshal(source);
            }
            catch (JAXBException e) {
                if (source instanceof StreamSource) {
                    for (Class<?> type2 : this.classesToBeBound) {
                        try {
                            return this.mapper.readValue(((StreamSource)source).getReader(), type2);
                        }
                        catch (JsonParseException | JsonMappingException throwable) {
                        }
                        catch (IOException io) {
                            logger.warn("Unable to read mail JSON object from source", (Throwable)io);
                            throw new CitrusRuntimeException("Failed to unmarshal source", (Throwable)io);
                        }
                    }
                }
                throw new CitrusRuntimeException("Failed to unmarshal source", (Throwable)e);
            }
        }
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            for (Class<?> type : this.classesToBeBound) {
                try {
                    return this.mapper.readValue(((StreamSource)source).getReader(), type);
                }
                catch (JsonParseException | JsonMappingException type2) {
                }
                catch (IOException io) {
                    throw new CitrusRuntimeException("Unable to read mail JSON object from source", (Throwable)io);
                }
            }
            throw new CitrusRuntimeException("Failed to read mail JSON object from source:" + source);
        }
        throw new CitrusRuntimeException("Unsupported mail marshaller type: " + this.type);
    }

    public void marshal(Object graph, Result result) {
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            if (result instanceof StringResult) {
                StringWriter writer = new StringWriter();
                ((StringResult)result).setWriter((Writer)writer);
                try {
                    this.mapper.writer().writeValue((Writer)writer, graph);
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to write mail object graph to result", (Throwable)e);
                }
            }
        } else if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                this.marshaller.marshal(graph, result);
            }
            catch (JAXBException e) {
                throw new CitrusRuntimeException("Failed to marshal object graph", (Throwable)e);
            }
        } else {
            throw new CitrusRuntimeException("Unsupported mail marshaller type: " + this.type);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

