/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.mail.config.annotation;

import java.util.Arrays;
import java.util.Properties;
import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.mail.config.annotation.MailServerConfig;
import org.citrusframework.mail.message.MailMessageConverter;
import org.citrusframework.mail.model.MailMarshaller;
import org.citrusframework.mail.server.MailServer;
import org.citrusframework.mail.server.MailServerBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;

public class MailServerConfigParser
implements AnnotationConfigParser<MailServerConfig, MailServer> {
    public MailServer parse(MailServerConfig annotation, ReferenceResolver referenceResolver) {
        MailServerBuilder builder = new MailServerBuilder();
        builder.autoStart(annotation.autoStart());
        builder.timeout(annotation.timeout());
        builder.debugLogging(annotation.debugLogging());
        if (StringUtils.hasText((String)annotation.endpointAdapter())) {
            builder.endpointAdapter((EndpointAdapter)referenceResolver.resolve(annotation.endpointAdapter(), EndpointAdapter.class));
        }
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        builder.port(annotation.port());
        builder.authRequired(annotation.authRequired());
        builder.autoAccept(annotation.autoAccept());
        builder.splitMultipart(annotation.splitMultipart());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((MailMessageConverter)referenceResolver.resolve(annotation.messageConverter(), MailMessageConverter.class));
        }
        if (annotation.knownUsers().length > 0) {
            builder.knownUsers(Arrays.asList(annotation.knownUsers()));
        }
        if (StringUtils.hasText((String)annotation.marshaller())) {
            builder.marshaller((MailMarshaller)referenceResolver.resolve(annotation.marshaller(), MailMarshaller.class));
        }
        if (StringUtils.hasText((String)annotation.javaMailProperties())) {
            builder.javaMailProperties((Properties)referenceResolver.resolve(annotation.javaMailProperties(), Properties.class));
        }
        return (MailServer)builder.initialize().build();
    }
}

