/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.endpoint.selector;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kafka.endpoint.selector.KafkaMessageByHeaderSelector;
import org.citrusframework.kafka.endpoint.selector.KafkaMessageSelector;

public class KafkaMessageSelectorFactory {
    private static final Map<Predicate<Map<String, Object>>, Function<Map<String, Object>, KafkaMessageSelector>> strategies = new HashMap<Predicate<Map<String, Object>>, Function<Map<String, Object>, KafkaMessageSelector>>();

    public <T> KafkaMessageSelector parseFromSelector(Map<String, T> messageSelectors) {
        return strategies.entrySet().stream().filter(strategy -> ((Predicate)strategy.getKey()).test(messageSelectors)).findFirst().map(Map.Entry::getValue).map(supplier -> (KafkaMessageSelector)supplier.apply(messageSelectors)).orElseThrow(() -> new CitrusRuntimeException("Cannot instantiate Kafka matcher from selectors: " + messageSelectors));
    }

    static {
        strategies.put(messageSelectors -> messageSelectors.containsKey("header-filter-key") || messageSelectors.containsKey("header-filter-value"), KafkaMessageByHeaderSelector::fromSelector);
    }
}

