/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.endpoint;

import java.time.Duration;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.kafka.endpoint.KafkaEndpointConfiguration;
import org.citrusframework.kafka.endpoint.KafkaMessageConsumerUtils;
import org.citrusframework.message.Message;
import org.citrusframework.messaging.AbstractMessageConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaMessageSingleConsumer
extends AbstractMessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageSingleConsumer.class);
    private final KafkaConsumer<Object, Object> consumer;

    public static KafkaMessageSingleConsumerBuilder builder() {
        return new KafkaMessageSingleConsumerBuilder();
    }

    private KafkaMessageSingleConsumer(KafkaEndpointConfiguration endpointConfiguration, KafkaConsumer<Object, Object> consumer) {
        super(KafkaMessageSingleConsumer.class.getSimpleName(), (EndpointConfiguration)endpointConfiguration);
        this.consumer = consumer;
    }

    public Message receive(TestContext testContext, long timeout) {
        ConsumerRecords consumerRecords;
        String topic = KafkaMessageConsumerUtils.resolveTopic(this.getEndpointConfiguration(), testContext);
        logger.debug("Receiving Kafka message on topic: '{}'", (Object)topic);
        if (this.consumer.subscription() == null || this.consumer.subscription().isEmpty()) {
            this.consumer.subscribe(Arrays.stream(topic.split(",")).toList());
        }
        if ((consumerRecords = this.consumer.poll(Duration.ofMillis(timeout))).isEmpty()) {
            throw new MessageTimeoutException(timeout, topic);
        }
        Message received = KafkaMessageConsumerUtils.parseConsumerRecordsToMessage(StreamSupport.stream(consumerRecords.spliterator(), false).toList(), this.getEndpointConfiguration(), testContext);
        this.consumer.commitSync(Duration.ofMillis(this.getEndpointConfiguration().getTimeout()));
        if (logger.isDebugEnabled()) {
            logger.info("Received Kafka message on topic '{}': {}", (Object)topic, (Object)received);
        } else {
            logger.info("Received Kafka message on topic '{}'", (Object)topic);
        }
        return received;
    }

    protected KafkaEndpointConfiguration getEndpointConfiguration() {
        return (KafkaEndpointConfiguration)super.getEndpointConfiguration();
    }

    public static class KafkaMessageSingleConsumerBuilder {
        private KafkaEndpointConfiguration endpointConfiguration;
        private KafkaConsumer<Object, Object> consumer;

        public KafkaMessageSingleConsumerBuilder endpointConfiguration(KafkaEndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public KafkaMessageSingleConsumerBuilder consumer(KafkaConsumer<Object, Object> consumer) {
            this.consumer = consumer;
            return this;
        }

        public KafkaMessageSingleConsumer build() {
            return new KafkaMessageSingleConsumer(this.endpointConfiguration, this.consumer);
        }
    }
}

