/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.config.annotation;

import java.util.Map;
import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kafka.config.annotation.KafkaEndpointConfig;
import org.citrusframework.kafka.endpoint.KafkaEndpoint;
import org.citrusframework.kafka.endpoint.KafkaEndpointBuilder;
import org.citrusframework.kafka.message.KafkaMessageConverter;
import org.citrusframework.kafka.message.KafkaMessageHeaderMapper;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;

public class KafkaEndpointConfigParser
implements AnnotationConfigParser<KafkaEndpointConfig, KafkaEndpoint> {
    public KafkaEndpoint parse(KafkaEndpointConfig annotation, ReferenceResolver referenceResolver) {
        KafkaEndpointBuilder builder = new KafkaEndpointBuilder();
        String server = annotation.server();
        if (!StringUtils.hasText((String)server)) {
            throw new CitrusRuntimeException("Required server is missing for kafka configuration");
        }
        builder.server(server);
        builder.topic(annotation.topic());
        builder.partition(annotation.partition());
        builder.autoCommit(annotation.autoCommit());
        builder.autoCommitInterval(annotation.autoCommitInterval());
        builder.offsetReset(annotation.offsetReset());
        if (StringUtils.hasText((String)annotation.clientId())) {
            builder.clientId(annotation.clientId());
        }
        builder.consumerGroup(annotation.consumerGroup());
        if (StringUtils.hasText((String)annotation.producerProperties())) {
            builder.producerProperties((Map)referenceResolver.resolve(annotation.producerProperties(), Map.class));
        }
        if (StringUtils.hasText((String)annotation.consumerProperties())) {
            builder.consumerProperties((Map)referenceResolver.resolve(annotation.consumerProperties(), Map.class));
        }
        builder.keySerializer(annotation.keySerializer());
        builder.keyDeserializer(annotation.keyDeserializer());
        builder.valueSerializer(annotation.valueSerializer());
        builder.valueDeserializer(annotation.valueDeserializer());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((KafkaMessageConverter)referenceResolver.resolve(annotation.messageConverter(), KafkaMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.headerMapper())) {
            builder.headerMapper((KafkaMessageHeaderMapper)referenceResolver.resolve(annotation.headerMapper(), KafkaMessageHeaderMapper.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (KafkaEndpoint)builder.initialize().build();
    }
}

