/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.message;

import java.io.IOException;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kafka.endpoint.KafkaEndpointConfiguration;
import org.citrusframework.kafka.message.KafkaMessage;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageConverter;
import org.citrusframework.util.FileUtils;
import org.springframework.core.io.Resource;

public class KafkaMessageConverter
implements MessageConverter<ConsumerRecord<Object, Object>, ProducerRecord<Object, Object>, KafkaEndpointConfiguration> {
    public ProducerRecord<Object, Object> convertOutbound(Message internalMessage, KafkaEndpointConfiguration endpointConfiguration, TestContext context) {
        Object payload;
        if (internalMessage.getPayload() instanceof String) {
            payload = context.replaceDynamicContentInString((String)internalMessage.getPayload(String.class));
        } else if (internalMessage.getPayload() instanceof Resource) {
            try {
                payload = context.replaceDynamicContentInString(FileUtils.readToString((Resource)((Resource)internalMessage.getPayload(Resource.class))));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read payload resource");
            }
        } else {
            payload = internalMessage.getPayload();
        }
        KafkaMessage kafkaMessage = internalMessage instanceof KafkaMessage ? (KafkaMessage)internalMessage : new KafkaMessage(internalMessage.getPayload(), internalMessage.getHeaders());
        return new ProducerRecord(Optional.ofNullable(kafkaMessage.getTopic()).map(arg_0 -> ((TestContext)context).replaceDynamicContentInString(arg_0)).orElse(context.replaceDynamicContentInString(endpointConfiguration.getTopic())), Optional.ofNullable(kafkaMessage.getPartition()).orElse(endpointConfiguration.getPartition()), kafkaMessage.getMessageKey(), payload, (Iterable)endpointConfiguration.getHeaderMapper().toHeaders(kafkaMessage.getHeaders(), context));
    }

    public void convertOutbound(ProducerRecord<Object, Object> externalMessage, Message internalMessage, KafkaEndpointConfiguration endpointConfiguration, TestContext context) {
    }

    public Message convertInbound(ConsumerRecord<Object, Object> consumerRecord, KafkaEndpointConfiguration endpointConfiguration, TestContext context) {
        if (consumerRecord == null) {
            return null;
        }
        return new KafkaMessage(consumerRecord.value(), endpointConfiguration.getHeaderMapper().fromHeaders(consumerRecord.headers())).topic(consumerRecord.topic()).timestamp(consumerRecord.timestamp()).partition(consumerRecord.partition()).offset(consumerRecord.offset()).messageKey(consumerRecord.key());
    }
}

