/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit.jupiter;

import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.citrusframework.TestClass;
import org.citrusframework.TestSource;
import org.citrusframework.junit.jupiter.main.JUnitCitrusTest;
import org.citrusframework.main.AbstractTestEngine;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.main.scan.ClassPathTestScanner;
import org.citrusframework.main.scan.JarFileTestScanner;
import org.citrusframework.util.StringUtils;
import org.junit.jupiter.api.Test;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitJupiterEngine
extends AbstractTestEngine {
    private static final Logger logger = LoggerFactory.getLogger(JUnitJupiterEngine.class);
    private final Set<TestExecutionListener> testExecutionListeners = new LinkedHashSet<TestExecutionListener>();
    private boolean printSummary = true;

    public JUnitJupiterEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    public void run() {
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
        if (this.getConfiguration().getTestSources().isEmpty()) {
            this.addTestPackages(requestBuilder, this.getConfiguration());
        } else {
            this.addTestClasses(requestBuilder, this.getConfiguration());
            this.addTestSources(requestBuilder, this.getConfiguration());
        }
        LauncherDiscoveryRequest request = requestBuilder.build();
        SummaryGeneratingListener listener = null;
        if (this.printSummary) {
            listener = new SummaryGeneratingListener();
        }
        try (LauncherSession session = LauncherFactory.openSession();){
            Launcher launcher = session.getLauncher();
            launcher.registerTestExecutionListeners((TestExecutionListener[])this.testExecutionListeners.toArray(TestExecutionListener[]::new));
            if (this.printSummary) {
                launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            }
            launcher.execute(request, new TestExecutionListener[0]);
        }
        if (this.printSummary && listener != null) {
            TestExecutionSummary summary = listener.getSummary();
            summary.printTo(new PrintWriter(System.out));
        }
    }

    private void addTestSources(LauncherDiscoveryRequestBuilder requestBuilder, TestRunConfiguration configuration) {
        List<TestSource> testSources = configuration.getTestSources().stream().filter(source -> !"java".equals(source.getType())).toList();
        for (TestSource source2 : testSources) {
            logger.info(String.format("Running test source %s", source2.getName()));
            JUnitCitrusTest.setSourceName(source2.getName());
            JUnitCitrusTest.setSource(Optional.ofNullable(source2.getFilePath()).orElse(""));
            requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(JUnitCitrusTest.class)});
        }
    }

    private void addTestPackages(LauncherDiscoveryRequestBuilder requestBuilder, TestRunConfiguration configuration) {
        List<String> packagesToRun = configuration.getPackages();
        if (packagesToRun == null || packagesToRun.isEmpty()) {
            packagesToRun = Collections.singletonList("");
            logger.info("Running all tests in project");
        }
        ArrayList selectors = new ArrayList();
        for (String packageName : packagesToRun) {
            if (StringUtils.hasText((String)packageName)) {
                logger.info(String.format("Running tests in package %s", packageName));
            }
            List classesToRun = configuration.getTestJar() != null ? new JarFileTestScanner(configuration.getTestJar(), configuration.getIncludes()).findTestsInPackage(packageName) : new ClassPathTestScanner(Test.class, configuration.getIncludes()).findTestsInPackage(packageName);
            classesToRun.stream().peek(testClass -> {
                Object[] objectArray = new Object[1];
                objectArray[0] = Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElseGet(() -> ((TestClass)testClass).getName());
                logger.info(String.format("Running test %s", objectArray));
            }).map(testClass -> {
                try {
                    Class<?> clazz = configuration.getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{configuration.getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                    return clazz;
                }
                catch (ClassNotFoundException | MalformedURLException e) {
                    logger.warn("Unable to read test class: " + testClass.getName());
                    return Void.class;
                }
            }).filter(clazz -> !clazz.equals(Void.class)).forEach(clazz -> selectors.add(DiscoverySelectors.selectClass((Class)clazz)));
            requestBuilder.selectors(selectors);
            logger.info(String.format("Found %s test classes to execute", selectors.size()));
        }
    }

    private void addTestClasses(LauncherDiscoveryRequestBuilder requestBuilder, TestRunConfiguration configuration) {
        List<TestClass> testClasses = configuration.getTestSources().stream().filter(source -> "java".equals(source.getType())).map(TestSource::getName).map(TestClass::fromString).toList();
        ArrayList<Object> selectors = new ArrayList<Object>();
        for (TestClass testClass : testClasses) {
            Object[] objectArray = new Object[1];
            objectArray[0] = Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElseGet(() -> ((TestClass)testClass).getName());
            logger.info(String.format("Running test %s", objectArray));
            try {
                Class<?> clazz = configuration.getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{configuration.getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                if (StringUtils.hasText((String)testClass.getMethod())) {
                    selectors.add(DiscoverySelectors.selectMethod(clazz, (String)testClass.getMethod()));
                    continue;
                }
                selectors.add(DiscoverySelectors.selectClass(clazz));
            }
            catch (ClassNotFoundException | MalformedURLException e) {
                logger.warn("Unable to read test class: " + testClass.getName());
            }
        }
        requestBuilder.selectors(selectors);
    }

    public JUnitJupiterEngine addTestListener(TestExecutionListener testExecutionListener) {
        this.testExecutionListeners.add(testExecutionListener);
        return this;
    }

    public JUnitJupiterEngine withPrintSummary(boolean enabled) {
        this.printSummary = enabled;
        return this;
    }
}

