/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit.jupiter.spring;

import java.lang.reflect.Method;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.CitrusContextProvider;
import org.citrusframework.CitrusSpringContext;
import org.citrusframework.CitrusSpringContextProvider;
import org.citrusframework.junit.jupiter.CitrusExtension;
import org.citrusframework.junit.jupiter.CitrusExtensionHelper;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class CitrusSpringExtension
implements BeforeAllCallback,
BeforeTestExecutionCallback,
InvocationInterceptor,
AfterTestExecutionCallback,
ParameterResolver,
TestInstancePostProcessor,
TestExecutionExceptionHandler,
AfterEachCallback {
    private Citrus citrus;
    private ApplicationContext applicationContext;
    private final CitrusExtension delegate = new CitrusExtension();

    public void beforeAll(ExtensionContext extensionContext) {
        CitrusExtensionHelper.setCitrus(this.getCitrus(extensionContext), extensionContext);
        this.delegate.beforeAll(extensionContext);
    }

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        this.delegate.handleTestExecutionException(extensionContext, throwable);
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        this.delegate.afterTestExecution(extensionContext);
    }

    public void beforeTestExecution(ExtensionContext extensionContext) {
        CitrusExtensionHelper.setCitrus(this.getCitrus(extensionContext), extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.delegate.interceptTestMethod(invocation, invocationContext, extensionContext);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.delegate.afterEach(extensionContext);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        this.delegate.postProcessTestInstance(testInstance, extensionContext);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.delegate.supportsParameter(parameterContext, extensionContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.delegate.resolveParameter(parameterContext, extensionContext);
    }

    protected Citrus getCitrus(ExtensionContext extensionContext) {
        CitrusSpringContext citrusSpringContext;
        CitrusContext citrusContext;
        ApplicationContext ctx = SpringExtension.getApplicationContext((ExtensionContext)extensionContext);
        Citrus existing = null;
        if (!CitrusExtensionHelper.requiresCitrus(extensionContext)) {
            existing = CitrusExtensionHelper.getCitrus(extensionContext);
        }
        if (this.applicationContext == null || !this.applicationContext.equals(ctx)) {
            this.applicationContext = ctx;
        }
        if (this.citrus == null) {
            CitrusSpringContext citrusSpringContext2;
            CitrusContext citrusContext2;
            if (existing != null && (citrusContext2 = existing.getCitrusContext()) instanceof CitrusSpringContext && (citrusSpringContext2 = (CitrusSpringContext)citrusContext2).getApplicationContext().equals(this.applicationContext)) {
                this.citrus = existing;
            } else {
                this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
                if (existing != null) {
                    this.citrus.getCitrusContext().handleTestResults(existing.getCitrusContext().getTestResults());
                }
            }
        } else if (existing == null || !((citrusContext = existing.getCitrusContext()) instanceof CitrusSpringContext) || !(citrusSpringContext = (CitrusSpringContext)citrusContext).getApplicationContext().equals(this.applicationContext)) {
            this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
        }
        return this.citrus;
    }
}

