/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit.jupiter;

import java.lang.reflect.Method;
import org.citrusframework.Citrus;
import org.citrusframework.DefaultTestCase;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestActionRunner;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestCaseRunnerFactory;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusTest;
import org.citrusframework.annotations.CitrusTestSource;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.junit.jupiter.CitrusExtension;
import org.citrusframework.junit.jupiter.CitrusTestFactory;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.util.StringUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public final class CitrusExtensionHelper {
    private CitrusExtensionHelper() {
    }

    public static boolean isTestFactoryMethod(Method method) {
        return method.isAnnotationPresent(CitrusTestFactory.class);
    }

    public static boolean isTestSourceMethod(Method method) {
        return method.isAnnotationPresent(CitrusTestSource.class);
    }

    public static TestCaseRunner createTestRunner(String testName, ExtensionContext extensionContext) {
        TestCaseRunner testCaseRunner = TestCaseRunnerFactory.createRunner((TestCase)new DefaultTestCase(), (TestContext)CitrusExtensionHelper.getTestContext(extensionContext));
        testCaseRunner.testClass(extensionContext.getRequiredTestClass());
        testCaseRunner.name(testName);
        testCaseRunner.packageName(extensionContext.getRequiredTestClass().getPackage().getName());
        return testCaseRunner;
    }

    public static TestCaseRunner getTestRunner(ExtensionContext extensionContext) {
        ObjectHelper.assertNotNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCaseRunner)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCaseRunner.class.getSimpleName()), key -> {
            CitrusTest citrusTestAnnotation;
            Object testName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
            if (extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class) != null && StringUtils.hasText((String)(citrusTestAnnotation = extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class)).name())) {
                testName = citrusTestAnnotation.name();
            }
            return CitrusExtensionHelper.createTestRunner((String)testName, extensionContext);
        }, TestCaseRunner.class);
    }

    public static TestLoader getTestLoader(ExtensionContext extensionContext) {
        ObjectHelper.assertNotNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestLoader)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestLoader.class.getSimpleName()), key -> CitrusExtensionHelper.createTestLoader(extensionContext), TestLoader.class);
    }

    public static TestCase getTestCase(ExtensionContext extensionContext) {
        ObjectHelper.assertNotNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCase.class.getSimpleName()), key -> {
            if (CitrusExtensionHelper.isTestSourceMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusExtensionHelper.getTestLoader(extensionContext).getTestCase();
            }
            return CitrusExtensionHelper.getTestRunner(extensionContext).getTestCase();
        }, TestCase.class);
    }

    public static TestLoader createTestLoader(ExtensionContext extensionContext) {
        DefaultTestLoader testLoader;
        Method method = extensionContext.getRequiredTestMethod();
        if (CitrusExtensionHelper.isTestFactoryMethod(method)) {
            DefaultTestLoader testLoader2 = new DefaultTestLoader();
            CitrusExtensionHelper.configure((TestLoader)testLoader2, extensionContext, method, new String[0], null, new String[0], new String[0]);
            return testLoader2;
        }
        if (CitrusExtensionHelper.isTestSourceMethod(method)) {
            CitrusTestSource citrusTestAnnotation = method.getAnnotation(CitrusTestSource.class);
            testLoader = (TestLoader)TestLoader.lookup((String)citrusTestAnnotation.type()).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", citrusTestAnnotation.type())));
            CitrusExtensionHelper.configure((TestLoader)testLoader, extensionContext, method, citrusTestAnnotation.name(), citrusTestAnnotation.packageName(), citrusTestAnnotation.packageScan(), citrusTestAnnotation.sources());
        } else {
            testLoader = new DefaultTestLoader();
            CitrusExtensionHelper.configure((TestLoader)testLoader, extensionContext, method, new String[0], null, new String[0], new String[0]);
        }
        return testLoader;
    }

    public static TestContext getTestContext(ExtensionContext extensionContext) {
        ObjectHelper.assertNotNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestContext)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestContext.class.getSimpleName()), key -> CitrusExtensionHelper.getCitrus(extensionContext).getCitrusContext().createTestContext(), TestContext.class);
    }

    public static String getBaseKey(ExtensionContext extensionContext) {
        return extensionContext.getRequiredTestClass().getName() + "." + extensionContext.getRequiredTestMethod().getName() + "#";
    }

    public static Citrus getCitrus(ExtensionContext extensionContext) {
        ObjectHelper.assertNotNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        Citrus citrus = (Citrus)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).get((Object)Citrus.class.getName(), Citrus.class);
        if (citrus == null) {
            throw new CitrusRuntimeException("Missing Citrus instance in JUnit5 extension context");
        }
        return citrus;
    }

    public static void setCitrus(Citrus citrus, ExtensionContext extensionContext) {
        ObjectHelper.assertNotNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).put((Object)Citrus.class.getName(), (Object)citrus);
    }

    public static Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        TestCaseRunner runner = CitrusExtensionHelper.getTestRunner(extensionContext);
        if (TestCaseRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return runner;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return runner;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return runner;
        }
        if (TestContext.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return CitrusExtensionHelper.getTestContext(extensionContext);
        }
        throw new CitrusRuntimeException(String.format("Failed to resolve parameter %s", parameterContext.getParameter()));
    }

    public static boolean requiresCitrus(ExtensionContext extensionContext) {
        ObjectHelper.assertNotNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        Citrus citrus = (Citrus)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).get((Object)Citrus.class.getName(), Citrus.class);
        return citrus == null;
    }

    private static void configure(TestLoader testLoader, ExtensionContext extensionContext, Method method, String[] methodNames, String methodPackageName, String[] packagesToScan, String[] sources) {
        String testName = extensionContext.getRequiredTestClass().getSimpleName();
        String packageName = method.getDeclaringClass().getPackage().getName();
        String source = null;
        if (StringUtils.hasText((String)methodPackageName)) {
            packageName = methodPackageName;
        }
        if (methodNames.length > 0) {
            testName = methodNames[0];
        } else if (packagesToScan.length == 0 && sources.length == 0) {
            testName = method.getName();
        }
        if (sources.length > 0) {
            source = sources[0];
            Resource file = FileUtils.getFileResource((String)source);
            testName = FileUtils.getBaseName((String)FileUtils.getFileName((String)file.getLocation()));
            packageName = source;
            if (packageName.startsWith("classpath:")) {
                packageName = source.substring("classpath:".length());
            }
            if (StringUtils.hasText((String)packageName) && packageName.contains("/")) {
                packageName = packageName.substring(0, packageName.lastIndexOf("/"));
            }
            packageName = packageName.replace("/", ".");
        }
        testLoader.setTestClass(extensionContext.getRequiredTestClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        CitrusAnnotations.injectAll((Object)testLoader, (Citrus)CitrusExtensionHelper.getCitrus(extensionContext));
        if (testLoader instanceof TestSourceAware) {
            ((TestSourceAware)testLoader).setSource(source);
        }
    }
}

