/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit;

import java.util.Date;
import org.citrusframework.Citrus;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestBehavior;
import org.citrusframework.TestCaseMetaInfo;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusTest;
import org.citrusframework.annotations.CitrusTestSource;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.junit.CitrusFrameworkMethod;
import org.citrusframework.junit.CitrusJUnit4Runner;
import org.citrusframework.junit.JUnit4Helper;
import org.junit.runner.RunWith;

@RunWith(value=CitrusJUnit4Runner.class)
public class JUnit4CitrusSupport
implements GherkinTestActionRunner,
CitrusFrameworkMethod.Runner {
    protected Citrus citrus;
    private TestCaseRunner delegate;

    @Override
    public void run(CitrusFrameworkMethod frameworkMethod) {
        if (frameworkMethod.hasError()) {
            throw frameworkMethod.getError();
        }
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance();
        }
        TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
        if (frameworkMethod.getMethod().getAnnotation(CitrusTest.class) != null || frameworkMethod.getMethod().getAnnotation(CitrusTestSource.class) != null) {
            TestCaseRunner runner = JUnit4Helper.createTestRunner(frameworkMethod, this.getClass(), ctx);
            frameworkMethod.setAttribute("builder", runner);
            this.delegate = runner;
            CitrusAnnotations.injectAll((Object)this, (Citrus)this.citrus, (TestContext)ctx);
            Object testLoader = frameworkMethod.getMethod().getAnnotation(CitrusTestSource.class) != null ? this.createTestLoader(frameworkMethod.getTestName(), frameworkMethod.getPackageName(), frameworkMethod.getSource(), frameworkMethod.getSourceType()) : new DefaultTestLoader();
            CitrusAnnotations.injectAll((Object)testLoader, (Citrus)this.citrus, (TestContext)ctx);
            CitrusAnnotations.injectTestRunner((Object)testLoader, (TestCaseRunner)runner);
            testLoader.doWithTestCase(t -> JUnit4Helper.invokeTestMethod(this, frameworkMethod, ctx));
            testLoader.load();
        }
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName, String source, String type) {
        TestLoader testLoader = (TestLoader)TestLoader.lookup((String)type).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", type)));
        testLoader.setTestClass(this.getClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        if (testLoader instanceof TestSourceAware) {
            ((TestSourceAware)testLoader).setSource(source);
        }
        return testLoader;
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.delegate.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.delegate.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.delegate.variable(name, value);
    }

    public void name(String name) {
        this.delegate.name(name);
    }

    public void description(String description) {
        this.delegate.description(description);
    }

    public void author(String author) {
        this.delegate.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.delegate.status(status);
    }

    public void creationDate(Date date) {
        this.delegate.creationDate(date);
    }
}

