/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointAdapter;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.jms.endpoint.JmsSyncEndpoint;
import org.citrusframework.jms.endpoint.JmsSyncEndpointConfiguration;
import org.citrusframework.jms.endpoint.JmsSyncProducer;
import org.citrusframework.jms.message.JmsMessageHeaderMapper;
import org.citrusframework.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsEndpointAdapter
extends AbstractEndpointAdapter {
    private final JmsSyncEndpoint endpoint;
    private final JmsSyncProducer producer;
    private final JmsSyncEndpointConfiguration endpointConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(JmsEndpointAdapter.class);

    public JmsEndpointAdapter(JmsSyncEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        if (this.endpointConfiguration.getHeaderMapper() instanceof JmsMessageHeaderMapper) {
            this.endpointConfiguration.setFilterInternalHeaders(false);
        }
        this.endpoint = new JmsSyncEndpoint(this.endpointConfiguration);
        this.endpoint.setName(this.getName());
        this.producer = new JmsSyncProducer(this.endpoint.getProducerName(), this.endpointConfiguration);
    }

    protected Message handleMessageInternal(Message request) {
        logger.debug("Forwarding request to jms destination ...");
        TestContext context = this.getTestContext();
        Message replyMessage = null;
        try {
            this.producer.send(request, context);
            replyMessage = this.endpointConfiguration.getCorrelator() != null ? this.producer.receive(this.endpointConfiguration.getCorrelator().getCorrelationKey(request), context, this.endpointConfiguration.getTimeout()) : this.producer.receive(context, this.endpointConfiguration.getTimeout());
        }
        catch (ActionTimeoutException e) {
            logger.warn(e.getMessage());
        }
        return replyMessage;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public JmsSyncEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }
}

