/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.actions;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DynamicDestinationResolver;

public class PurgeJmsQueuesAction
extends AbstractTestAction {
    private final List<String> queueNames;
    private final List<Queue> queues;
    private final ConnectionFactory connectionFactory;
    private final long receiveTimeout;
    private final long sleepTime;
    private static final Logger logger = LoggerFactory.getLogger(PurgeJmsQueuesAction.class);

    public PurgeJmsQueuesAction(Builder builder) {
        super("purge-queue", (AbstractTestActionBuilder)builder);
        this.queueNames = builder.queueNames;
        this.queues = builder.queues;
        this.connectionFactory = builder.connectionFactory;
        this.receiveTimeout = builder.receiveTimeout;
        this.sleepTime = builder.sleepTime;
    }

    public void doExecute(TestContext context) {
        logger.debug("Purging JMS queues...");
        Connection connection = null;
        Session session = null;
        try {
            connection = this.createConnection();
            session = this.createSession(connection);
            connection.start();
            for (Queue queue : this.queues) {
                this.purgeQueue(queue, session);
            }
            for (String queueName : this.queueNames) {
                this.purgeQueue(context.replaceDynamicContentInString(queueName), session);
            }
        }
        catch (JMSException e) {
            try {
                logger.error("Error while establishing jms connection", (Throwable)e);
                throw new CitrusRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(session);
                JmsUtils.closeConnection((Connection)connection, (boolean)true);
                throw throwable;
            }
        }
        JmsUtils.closeSession((Session)session);
        JmsUtils.closeConnection((Connection)connection, (boolean)true);
        logger.info("Purged JMS queues");
    }

    private void purgeQueue(String queueName, Session session) throws JMSException {
        this.purgeDestination(this.getDestination(session, queueName), session, queueName);
    }

    private void purgeQueue(Queue queue, Session session) throws JMSException {
        this.purgeDestination((Destination)queue, session, queue.getQueueName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeDestination(Destination destination, Session session, String destinationName) throws JMSException {
        if (logger.isDebugEnabled()) {
            logger.debug("Try to purge destination " + destinationName);
        }
        int messagesPurged = 0;
        MessageConsumer messageConsumer = session.createConsumer(destination);
        try {
            Message message;
            do {
                Message message2 = message = this.receiveTimeout >= 0L ? messageConsumer.receive(this.receiveTimeout) : messageConsumer.receive();
                if (message == null) continue;
                logger.debug("Removed message from destination " + destinationName);
                ++messagesPurged;
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted during wait", (Throwable)e);
                }
            } while (message != null);
            if (logger.isDebugEnabled()) {
                logger.debug("Purged " + messagesPurged + " messages from destination");
            }
        }
        finally {
            JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        }
    }

    private Destination getDestination(Session session, String queueName) throws JMSException {
        return new DynamicDestinationResolver().resolveDestinationName(session, queueName, false);
    }

    protected Connection createConnection() throws JMSException {
        if (this.connectionFactory instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
        }
        return this.connectionFactory.createConnection();
    }

    protected Session createSession(Connection connection) throws JMSException {
        if (connection instanceof QueueConnection) {
            return ((QueueConnection)connection).createQueueSession(false, 1);
        }
        return connection.createSession(false, 1);
    }

    public List<String> getQueueNames() {
        return this.queueNames;
    }

    public List<Queue> getQueues() {
        return this.queues;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<PurgeJmsQueuesAction, Builder>
    implements ReferenceResolverAware {
        private final List<String> queueNames = new ArrayList<String>();
        private final List<Queue> queues = new ArrayList<Queue>();
        private ConnectionFactory connectionFactory;
        private long receiveTimeout = 100L;
        private long sleepTime = 350L;
        private ReferenceResolver referenceResolver;

        public static Builder purgeQueues() {
            return new Builder();
        }

        public Builder connectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder queues(List<Queue> queues) {
            this.queues.addAll(queues);
            return this;
        }

        public Builder queues(Queue ... queues) {
            return this.queues(Arrays.asList(queues));
        }

        public Builder queue(Queue queue) {
            this.queues.add(queue);
            return this;
        }

        public Builder queueNames(List<String> names) {
            this.queueNames.addAll(names);
            return this;
        }

        public Builder queueNames(String ... names) {
            return this.queueNames(Arrays.asList(names));
        }

        public Builder queue(String name) {
            this.queueNames.add(name);
            return this;
        }

        public Builder timeout(long receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
            return this;
        }

        public Builder sleep(long millis) {
            this.sleepTime = millis;
            return this;
        }

        public Builder withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public PurgeJmsQueuesAction build() {
            if (this.connectionFactory == null && this.referenceResolver != null && this.referenceResolver.isResolvable("connectionFactory")) {
                this.connectionFactory((ConnectionFactory)this.referenceResolver.resolve("connectionFactory", ConnectionFactory.class));
            }
            return new PurgeJmsQueuesAction(this);
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }
    }
}

