/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.message;

import jakarta.jms.Message;
import jakarta.jms.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.citrusframework.CitrusSettings;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jms.endpoint.JmsEndpointConfiguration;
import org.citrusframework.jms.message.JmsMessageConverter;
import org.citrusframework.message.MessageHeaderUtils;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.xml.StringResult;
import org.citrusframework.xml.StringSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapMessageFactory;

public class SoapJmsMessageConverter
extends JmsMessageConverter
implements InitializingPhase,
ReferenceResolverAware {
    private static final Logger logger = LoggerFactory.getLogger(SoapJmsMessageConverter.class);
    private SoapMessageFactory soapMessageFactory;
    private ReferenceResolver referenceResolver;
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final String SOAP_ACTION_HEADER = "citrus_soap_action";
    private String jmsSoapActionHeader = "SOAPJMS_soapAction";

    @Override
    public org.citrusframework.message.Message convertInbound(Message jmsMessage, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        try {
            SoapHeader soapHeader;
            org.citrusframework.message.Message message = super.convertInbound(jmsMessage, endpointConfiguration, context);
            ByteArrayInputStream in = new ByteArrayInputStream(((String)message.getPayload(String.class)).getBytes(CitrusSettings.CITRUS_FILE_ENCODING));
            SoapMessage soapMessage = this.soapMessageFactory.createWebServiceMessage((InputStream)in);
            StringResult payload = new StringResult();
            this.transformerFactory.newTransformer().transform(soapMessage.getPayloadSource(), (Result)payload);
            if (message.getHeader(this.jmsSoapActionHeader) != null) {
                message.setHeader(SOAP_ACTION_HEADER, message.getHeader(this.jmsSoapActionHeader));
            }
            if ((soapHeader = soapMessage.getSoapHeader()) != null) {
                Iterator iter = soapHeader.examineAllHeaderElements();
                while (iter.hasNext()) {
                    SoapHeaderElement headerEntry = (SoapHeaderElement)iter.next();
                    MessageHeaderUtils.setHeader((org.citrusframework.message.Message)message, (String)headerEntry.getName().getLocalPart(), (String)headerEntry.getText());
                }
                if (soapHeader.getSource() != null) {
                    StringResult headerData = new StringResult();
                    Transformer transformer = this.transformerFactory.newTransformer();
                    transformer.transform(soapHeader.getSource(), (Result)headerData);
                    message.addHeaderData(headerData.toString());
                }
            }
            message.setPayload((Object)payload.toString());
            return message;
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to transform SOAP message body to payload", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CitrusRuntimeException("Found unsupported default encoding", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read SOAP message payload", (Throwable)e);
        }
    }

    @Override
    public Message createJmsMessage(org.citrusframework.message.Message message, Session session, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        String payload = (String)message.getPayload(String.class);
        logger.debug("Creating SOAP message from payload: " + payload);
        try {
            SoapMessage soapMessage = this.soapMessageFactory.createWebServiceMessage();
            this.transformerFactory.newTransformer().transform((Source)new StringSource(payload), soapMessage.getPayloadResult());
            if (message.getHeader(SOAP_ACTION_HEADER) != null) {
                message.setHeader(this.jmsSoapActionHeader, message.getHeader(SOAP_ACTION_HEADER));
                message.removeHeader(SOAP_ACTION_HEADER);
            }
            for (String headerData : message.getHeaderData()) {
                try {
                    Transformer transformer = this.transformerFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform((Source)new StringSource(headerData), soapMessage.getSoapHeader().getResult());
                }
                catch (TransformerException e) {
                    throw new CitrusRuntimeException("Failed to write SOAP header content", (Throwable)e);
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)bos);
            message.setPayload((Object)new String(bos.toByteArray()));
            return super.createJmsMessage(message, session, endpointConfiguration, context);
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to transform payload to SOAP body", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write SOAP message content", (Throwable)e);
        }
    }

    public void setJmsSoapActionHeader(String jmsSoapActionHeader) {
        this.jmsSoapActionHeader = jmsSoapActionHeader;
    }

    public String getJmsSoapActionHeader() {
        return this.jmsSoapActionHeader;
    }

    public void initialize() {
        if (this.soapMessageFactory == null) {
            ObjectHelper.assertNotNull((Object)this.referenceResolver, (String)"Missing reference resolver for auto configuration of soap message factory");
            this.soapMessageFactory = (SoapMessageFactory)this.referenceResolver.resolve(SoapMessageFactory.class);
        }
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public SoapMessageFactory getSoapMessageFactory() {
        return this.soapMessageFactory;
    }

    public void setSoapMessageFactory(SoapMessageFactory soapMessageFactory) {
        this.soapMessageFactory = soapMessageFactory;
    }
}

