/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import org.citrusframework.endpoint.AbstractPollableEndpointConfiguration;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jms.endpoint.resolver.DynamicDestinationNameResolver;
import org.citrusframework.jms.message.JmsMessageConverter;
import org.citrusframework.jms.message.JmsMessageHeaderMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.JmsHeaderMapper;
import org.springframework.jms.support.destination.DestinationResolver;

public class JmsEndpointConfiguration
extends AbstractPollableEndpointConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JmsEndpointConfiguration.class);
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private String destinationName;
    private DestinationResolver destinationResolver;
    private EndpointUriResolver destinationNameResolver = new DynamicDestinationNameResolver();
    private JmsTemplate jmsTemplate;
    private JmsHeaderMapper headerMapper = new JmsMessageHeaderMapper();
    private JmsMessageConverter messageConverter = new JmsMessageConverter();
    private boolean pubSubDomain = false;
    private boolean autoStart = false;
    private boolean durableSubscription = false;
    private String durableSubscriberName;
    private boolean useObjectMessages = false;
    private boolean filterInternalHeaders = true;

    public String getDestinationName(Destination destination) {
        try {
            if (destination instanceof Queue) {
                return ((Queue)destination).getQueueName();
            }
            if (destination instanceof Topic) {
                return ((Topic)destination).getTopicName();
            }
            return destination.toString();
        }
        catch (JMSException e) {
            logger.error("Unable to resolve destination name", (Throwable)e);
            return "";
        }
    }

    private void createJmsTemplate() {
        if (this.connectionFactory == null) {
            throw new CitrusRuntimeException("Neither 'jmsTemplate' nor 'connectionFactory' is set correctly.");
        }
        this.jmsTemplate = new JmsTemplate();
        this.jmsTemplate.setConnectionFactory(this.connectionFactory);
        if (this.destination != null) {
            this.jmsTemplate.setDefaultDestination(this.destination);
        } else if (this.destinationName != null) {
            this.jmsTemplate.setDefaultDestinationName(this.destinationName);
        }
        if (this.destinationResolver != null) {
            this.jmsTemplate.setDestinationResolver(this.destinationResolver);
        }
        this.jmsTemplate.setPubSubDomain(this.pubSubDomain);
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public JmsTemplate getJmsTemplate() {
        if (this.jmsTemplate == null) {
            this.createJmsTemplate();
        }
        return this.jmsTemplate;
    }

    public JmsMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(JmsMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public JmsHeaderMapper getHeaderMapper() {
        return this.headerMapper;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public boolean isUseObjectMessages() {
        return this.useObjectMessages;
    }

    public void setUseObjectMessages(boolean useObjectMessages) {
        this.useObjectMessages = useObjectMessages;
    }

    public boolean isFilterInternalHeaders() {
        return this.filterInternalHeaders;
    }

    public void setFilterInternalHeaders(boolean filterInternalHeaders) {
        this.filterInternalHeaders = filterInternalHeaders;
        if (this.headerMapper instanceof JmsMessageHeaderMapper) {
            ((JmsMessageHeaderMapper)this.headerMapper).setFilterInternalHeaders(filterInternalHeaders);
        }
    }

    public EndpointUriResolver getDestinationNameResolver() {
        return this.destinationNameResolver;
    }

    public void setDestinationNameResolver(EndpointUriResolver destinationNameResolver) {
        this.destinationNameResolver = destinationNameResolver;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isDurableSubscription() {
        return this.durableSubscription;
    }

    public void setDurableSubscription(boolean durableSubscription) {
        this.durableSubscription = durableSubscription;
    }

    public String getDurableSubscriberName() {
        return this.durableSubscriberName;
    }

    public void setDurableSubscriberName(String durableSubscriberName) {
        this.durableSubscriberName = durableSubscriberName;
    }
}

