/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.config.xml;

import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractEndpointParser;
import org.citrusframework.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractJmsEndpointParser
extends AbstractEndpointParser {
    protected void parseEndpointConfiguration(BeanDefinitionBuilder endpointConfiguration, Element element, ParserContext parserContext) {
        super.parseEndpointConfiguration(endpointConfiguration, element, parserContext);
        String jmsTemplate = element.getAttribute("jms-template");
        String destination = element.getAttribute("destination");
        String destinationName = element.getAttribute("destination-name");
        if (StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
            String connectionFactory = "connectionFactory";
            if (element.hasAttribute("connection-factory")) {
                connectionFactory = element.getAttribute("connection-factory");
            }
            if (!StringUtils.hasText((String)connectionFactory)) {
                parserContext.getReaderContext().error("Attribute connection-factory must not be empty for jms configuration elements", (Object)element);
            }
            endpointConfiguration.addPropertyReference("connectionFactory", connectionFactory);
            if (StringUtils.hasText((String)destination)) {
                endpointConfiguration.addPropertyReference("destination", destination);
            } else {
                endpointConfiguration.addPropertyValue("destinationName", (Object)destinationName);
            }
        } else if (StringUtils.hasText((String)jmsTemplate)) {
            if (element.hasAttribute("connection-factory") || element.hasAttribute("destination") || element.hasAttribute("destination-name")) {
                parserContext.getReaderContext().error("When providing a jms-template, none of connection-factory, destination, or destination-name should be provided.", (Object)element);
            }
            endpointConfiguration.addPropertyReference("jmsTemplate", jmsTemplate);
        } else {
            parserContext.getReaderContext().error("Either a jms-template reference or one of destination or destination-name must be provided.", (Object)element);
        }
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("pub-sub-domain"), (String)"pubSubDomain");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("use-object-messages"), (String)"useObjectMessages");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("filter-internal-headers"), (String)"filterInternalHeaders");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("message-converter"), (String)"messageConverter");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("destination-resolver"), (String)"destinationResolver");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("destination-name-resolver"), (String)"destinationNameResolver");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("polling-interval"), (String)"pollingInterval");
    }
}

