/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.config.annotation;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jms.config.annotation.JmsSyncEndpointConfig;
import org.citrusframework.jms.endpoint.JmsSyncEndpoint;
import org.citrusframework.jms.endpoint.JmsSyncEndpointBuilder;
import org.citrusframework.jms.message.JmsMessageConverter;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.DestinationResolver;

public class JmsSyncEndpointConfigParser
implements AnnotationConfigParser<JmsSyncEndpointConfig, JmsSyncEndpoint> {
    public JmsSyncEndpoint parse(JmsSyncEndpointConfig annotation, ReferenceResolver referenceResolver) {
        JmsSyncEndpointBuilder builder = new JmsSyncEndpointBuilder();
        String jmsTemplate = annotation.jmsTemplate();
        String destination = annotation.destination();
        String destinationName = annotation.destinationName();
        if (StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
            if (StringUtils.hasText((String)jmsTemplate)) {
                throw new CitrusRuntimeException("When providing a jms-template, none of connection-factory, destination, or destination-name should be provided");
            }
            String connectionFactory = "connectionFactory";
            if (StringUtils.hasText((String)annotation.connectionFactory())) {
                connectionFactory = annotation.connectionFactory();
            }
            builder.connectionFactory((ConnectionFactory)referenceResolver.resolve(connectionFactory, ConnectionFactory.class));
            if (StringUtils.hasText((String)destination)) {
                builder.destination((Destination)referenceResolver.resolve(annotation.destination(), Destination.class));
            } else {
                builder.destination(annotation.destinationName());
            }
        } else if (StringUtils.hasText((String)jmsTemplate)) {
            if (StringUtils.hasText((String)annotation.connectionFactory())) {
                throw new CitrusRuntimeException("When providing a jms-template, none of connection-factory, destination, or destination-name should be provided");
            }
            builder.jmsTemplate((JmsTemplate)referenceResolver.resolve(jmsTemplate, JmsTemplate.class));
        } else {
            throw new CitrusRuntimeException("Either a jms-template reference or one of destination or destination-name must be provided");
        }
        builder.pubSubDomain(annotation.pubSubDomain());
        builder.useObjectMessages(annotation.useObjectMessages());
        builder.filterInternalHeaders(annotation.filterInternalHeaders());
        builder.messageConverter((JmsMessageConverter)referenceResolver.resolve(annotation.messageConverter(), JmsMessageConverter.class));
        if (StringUtils.hasText((String)annotation.destinationResolver())) {
            builder.destinationResolver((DestinationResolver)referenceResolver.resolve(annotation.destinationResolver(), DestinationResolver.class));
        }
        if (StringUtils.hasText((String)annotation.destinationNameResolver())) {
            builder.destinationNameResolver((EndpointUriResolver)referenceResolver.resolve(annotation.destinationNameResolver(), EndpointUriResolver.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        if (StringUtils.hasText((String)annotation.replyDestination())) {
            builder.replyDestination((Destination)referenceResolver.resolve(annotation.replyDestination(), Destination.class));
        }
        if (StringUtils.hasText((String)annotation.replyDestinationName())) {
            builder.replyDestination(annotation.replyDestinationName());
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        return (JmsSyncEndpoint)builder.initialize().build();
    }
}

