/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.xml;

import jakarta.jms.ConnectionFactory;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActor;
import org.citrusframework.jms.actions.PurgeJmsQueuesAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"description", "queues"})
@XmlRootElement(name="purge-jms-queues")
public class PurgeQueues
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    @XmlTransient
    private final PurgeJmsQueuesAction.Builder builder = new PurgeJmsQueuesAction.Builder();
    @XmlElement
    private String description;
    @XmlAttribute
    private String actor;
    @XmlAttribute
    protected String connectionFactory;
    @XmlAttribute
    protected String timeout;
    @XmlAttribute
    protected String sleep;
    @XmlElement(name="queue")
    protected List<Queue> queues;
    @XmlTransient
    private ReferenceResolver referenceResolver;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String getActor() {
        return this.actor;
    }

    public void setConnectionFactory(String connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setSleep(String sleep) {
        this.sleep = sleep;
    }

    public String getSleep() {
        return this.sleep;
    }

    public void setQueues(List<Queue> queues) {
        this.queues = queues;
    }

    public List<Queue> getQueues() {
        if (this.queues == null) {
            this.queues = new ArrayList<Queue>();
        }
        return this.queues;
    }

    public TestAction build() {
        this.builder.setReferenceResolver(this.referenceResolver);
        this.builder.description(this.description);
        for (Queue queue : this.getQueues()) {
            if (queue.name != null) {
                this.builder.queue(queue.getName());
            }
            if (queue.ref == null || this.referenceResolver == null) continue;
            this.builder.queue((jakarta.jms.Queue)this.referenceResolver.resolve(queue.ref, jakarta.jms.Queue.class));
        }
        if (this.timeout != null) {
            this.builder.timeout(Long.parseLong(this.timeout));
        }
        if (this.sleep != null) {
            this.builder.sleep(Long.parseLong(this.sleep));
        }
        if (this.referenceResolver != null) {
            if (this.actor != null) {
                this.builder.actor((TestActor)this.referenceResolver.resolve(this.actor, TestActor.class));
            }
            if (this.connectionFactory != null) {
                this.builder.connectionFactory((ConnectionFactory)this.referenceResolver.resolve(this.connectionFactory, ConnectionFactory.class));
            }
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={})
    public static class Queue {
        @XmlAttribute
        protected String name;
        @XmlAttribute
        protected String ref;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public String getRef() {
            return this.ref;
        }
    }
}

