/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.message;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jms.endpoint.JmsEndpointConfiguration;
import org.citrusframework.jms.message.JmsMessage;
import org.citrusframework.message.MessageConverter;
import org.springframework.jms.support.JmsUtils;
import org.springframework.messaging.MessageHeaders;

public class JmsMessageConverter
implements MessageConverter<Message, Message, JmsEndpointConfiguration> {
    public Message convertOutbound(org.citrusframework.message.Message message, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        Message message2;
        Connection connection = null;
        Session session = null;
        try {
            connection = endpointConfiguration.getConnectionFactory().createConnection();
            session = connection.createSession(false, 1);
            message2 = this.createJmsMessage(message, session, endpointConfiguration, context);
        }
        catch (JMSException e) {
            try {
                throw new CitrusRuntimeException("Failed to create JMS message", (Throwable)e);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(session);
                JmsUtils.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        JmsUtils.closeSession((Session)session);
        JmsUtils.closeConnection((Connection)connection);
        return message2;
    }

    public void convertOutbound(Message jmsMessage, org.citrusframework.message.Message message, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        Map headers = message.getHeaders();
        if (headers != null) {
            endpointConfiguration.getHeaderMapper().fromHeaders(new MessageHeaders(headers), (Object)jmsMessage);
        }
    }

    public org.citrusframework.message.Message convertInbound(Message jmsMessage, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        if (jmsMessage == null) {
            return null;
        }
        try {
            Serializable payload;
            MessageHeaders headers = endpointConfiguration.getHeaderMapper().toHeaders((Object)jmsMessage);
            if (jmsMessage instanceof TextMessage) {
                payload = ((TextMessage)jmsMessage).getText();
            } else if (jmsMessage instanceof BytesMessage) {
                byte[] bytes = new byte[(int)((BytesMessage)jmsMessage).getBodyLength()];
                ((BytesMessage)jmsMessage).readBytes(bytes);
                payload = (Serializable)bytes;
            } else if (jmsMessage instanceof MapMessage) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Enumeration en = ((MapMessage)jmsMessage).getMapNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    map.put(key, ((MapMessage)jmsMessage).getObject(key));
                }
                payload = map;
            } else {
                payload = jmsMessage instanceof ObjectMessage ? ((ObjectMessage)jmsMessage).getObject() : jmsMessage;
            }
            if (payload instanceof org.citrusframework.message.Message) {
                org.citrusframework.message.Message nestedMessage = (org.citrusframework.message.Message)payload;
                for (Map.Entry headerEntry : headers.entrySet()) {
                    if (((String)headerEntry.getKey()).startsWith("citrus_message_")) continue;
                    nestedMessage.setHeader((String)headerEntry.getKey(), headerEntry.getValue());
                }
                return nestedMessage;
            }
            JmsMessage message = new JmsMessage(payload);
            for (Map.Entry headerEntry : headers.entrySet()) {
                if (((String)headerEntry.getKey()).startsWith("citrus_message_")) continue;
                message.setHeader((String)headerEntry.getKey(), headerEntry.getValue());
            }
            return message;
        }
        catch (JMSException e) {
            throw new CitrusRuntimeException("Failed to convert jms message", (Throwable)e);
        }
    }

    public Message createJmsMessage(org.citrusframework.message.Message message, Session session, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        try {
            ObjectMessage jmsMessage;
            Object payload = message.getPayload();
            if (endpointConfiguration.isUseObjectMessages()) {
                jmsMessage = session.createObjectMessage((Serializable)message);
            } else if (payload instanceof Message) {
                jmsMessage = (Message)payload;
            } else if (payload instanceof String) {
                jmsMessage = session.createTextMessage((String)payload);
            } else if (payload instanceof byte[]) {
                jmsMessage = session.createBytesMessage();
                ((BytesMessage)jmsMessage).writeBytes((byte[])payload);
            } else if (payload instanceof Map) {
                jmsMessage = session.createMapMessage();
                Map map = (Map)payload;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getKey() instanceof String)) {
                        throw new CitrusRuntimeException("Cannot convert non-String key of type [" + entry.getKey() + "] to JMS MapMessage entry");
                    }
                    ((MapMessage)jmsMessage).setObject((String)entry.getKey(), entry.getValue());
                }
            } else if (payload instanceof Serializable) {
                jmsMessage = session.createObjectMessage((Serializable)payload);
            } else {
                throw new CitrusRuntimeException("Cannot convert object of type [" + payload + "] to JMS message. Supported message payloads are: String, byte array, Map<String,?>, Serializable object.");
            }
            this.convertOutbound((Message)jmsMessage, message, endpointConfiguration, context);
            return jmsMessage;
        }
        catch (JMSException e) {
            throw new CitrusRuntimeException("Failed to convert jms message", (Throwable)e);
        }
    }
}

