/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.PollableEndpointConfiguration;
import org.citrusframework.jms.endpoint.JmsConsumer;
import org.citrusframework.jms.endpoint.JmsSyncEndpointConfiguration;
import org.citrusframework.jms.message.JmsMessage;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.PollingCorrelationManager;
import org.citrusframework.messaging.ReplyProducer;
import org.citrusframework.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSyncConsumer
extends JmsConsumer
implements ReplyProducer {
    private CorrelationManager<Destination> correlationManager;
    private final JmsSyncEndpointConfiguration endpointConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(JmsSyncConsumer.class);

    public JmsSyncConsumer(String name, JmsSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply jms destination not set up yet");
    }

    @Override
    public org.citrusframework.message.Message receive(String selector, TestContext context, long timeout) {
        org.citrusframework.message.Message receivedMessage = super.receive(selector, context, timeout);
        JmsMessage jmsMessage = receivedMessage instanceof JmsMessage ? (JmsMessage)receivedMessage : new JmsMessage(receivedMessage);
        this.saveReplyDestination(jmsMessage, context);
        return jmsMessage;
    }

    public void send(org.citrusframework.message.Message message, TestContext context) {
        ObjectHelper.assertNotNull((Object)message, (String)"Message is empty - unable to send empty message");
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.correlationManager.getCorrelationKey(correlationKeyName, context);
        Destination replyDestination = (Destination)this.correlationManager.find(correlationKey, this.endpointConfiguration.getTimeout());
        ObjectHelper.assertNotNull((Object)replyDestination, (String)("Failed to find JMS reply destination for message correlation key: '" + correlationKey + "'"));
        if (logger.isDebugEnabled()) {
            logger.debug("Sending JMS message to destination: '" + this.endpointConfiguration.getDestinationName(replyDestination) + "'");
        }
        this.endpointConfiguration.getJmsTemplate().send(replyDestination, session -> {
            Message jmsMessage = this.endpointConfiguration.getMessageConverter().createJmsMessage(message, session, this.endpointConfiguration, context);
            this.endpointConfiguration.getMessageConverter().convertOutbound(jmsMessage, message, this.endpointConfiguration, context);
            return jmsMessage;
        });
        context.onOutboundMessage(message);
        logger.info("Message was sent to JMS destination: '" + this.endpointConfiguration.getDestinationName(replyDestination) + "'");
    }

    public void saveReplyDestination(JmsMessage jmsMessage, TestContext context) {
        if (jmsMessage.getReplyTo() != null) {
            String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
            String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey((org.citrusframework.message.Message)jmsMessage);
            this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
            this.correlationManager.store(correlationKey, (Object)jmsMessage.getReplyTo());
        } else {
            logger.warn("Unable to retrieve reply to destination for message \n" + jmsMessage + "\n - no reply to destination found in message headers!");
        }
    }

    public CorrelationManager<Destination> getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(CorrelationManager<Destination> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

