/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jms.endpoint.JmsEndpointConfiguration;
import org.citrusframework.messaging.Producer;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsProducer
implements Producer {
    private static final Logger logger = LoggerFactory.getLogger(JmsProducer.class);
    private final String name;
    private final JmsEndpointConfiguration endpointConfiguration;

    public JmsProducer(String name, JmsEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(org.citrusframework.message.Message message, TestContext context) {
        ObjectHelper.assertNotNull((Object)message, (String)"Message is empty - unable to send empty message");
        if (this.endpointConfiguration.getDestination() != null) {
            this.send(message, this.endpointConfiguration.getDestination(), context);
        } else if (StringUtils.hasText((String)this.endpointConfiguration.getDestinationName())) {
            if (this.endpointConfiguration.getDestinationNameResolver() != null) {
                this.send(message, context.replaceDynamicContentInString(this.endpointConfiguration.getDestinationNameResolver().resolveEndpointUri(message, this.endpointConfiguration.getDestinationName())), context);
            } else {
                this.send(message, context.replaceDynamicContentInString(this.endpointConfiguration.getDestinationName()), context);
            }
        } else if (this.endpointConfiguration.getJmsTemplate().getDefaultDestination() != null) {
            this.send(message, this.endpointConfiguration.getJmsTemplate().getDefaultDestination(), context);
        } else if (StringUtils.hasText((String)this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName())) {
            this.send(message, context.replaceDynamicContentInString(this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName()), context);
        } else {
            throw new CitrusRuntimeException("Unable to send message - JMS destination not set");
        }
        context.onOutboundMessage(message);
    }

    private void send(org.citrusframework.message.Message message, String destinationName, TestContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending JMS message to destination: '" + destinationName + "'");
        }
        this.endpointConfiguration.getJmsTemplate().send(destinationName, session -> {
            Message jmsMessage = this.endpointConfiguration.getMessageConverter().createJmsMessage(message, session, this.endpointConfiguration, context);
            this.endpointConfiguration.getMessageConverter().convertOutbound(jmsMessage, message, this.endpointConfiguration, context);
            return jmsMessage;
        });
        logger.info("Message was sent to JMS destination: '" + destinationName + "'");
    }

    private void send(org.citrusframework.message.Message message, Destination destination, TestContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending JMS message to destination: '" + this.endpointConfiguration.getDestinationName(destination) + "'");
        }
        this.endpointConfiguration.getJmsTemplate().send(destination, session -> {
            Message jmsMessage = this.endpointConfiguration.getMessageConverter().createJmsMessage(message, session, this.endpointConfiguration, context);
            this.endpointConfiguration.getMessageConverter().convertOutbound(jmsMessage, message, this.endpointConfiguration, context);
            return jmsMessage;
        });
        logger.info("Message was sent to JMS destination: '" + this.endpointConfiguration.getDestinationName(destination) + "'");
    }

    public String getName() {
        return this.name;
    }
}

