/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint;

import jakarta.jms.ConnectionFactory;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointComponent;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.jms.endpoint.JmsEndpoint;
import org.citrusframework.jms.endpoint.JmsSyncEndpoint;

public class JmsEndpointComponent
extends AbstractEndpointComponent {
    public JmsEndpointComponent() {
        super("jms");
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        JmsEndpoint endpoint = resourcePath.startsWith("sync:") ? new JmsSyncEndpoint() : new JmsEndpoint();
        if (resourcePath.contains("topic:")) {
            endpoint.getEndpointConfiguration().setPubSubDomain(true);
        }
        if (resourcePath.indexOf(58) > 0) {
            endpoint.getEndpointConfiguration().setDestinationName(resourcePath.substring(resourcePath.lastIndexOf(58) + 1));
        } else {
            endpoint.getEndpointConfiguration().setDestinationName(resourcePath);
        }
        if (context.getReferenceResolver() != null && context.getReferenceResolver().isResolvable("connectionFactory")) {
            endpoint.getEndpointConfiguration().setConnectionFactory((ConnectionFactory)context.getReferenceResolver().resolve("connectionFactory", ConnectionFactory.class));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)endpoint.getEndpointConfiguration(), parameters, context);
        return endpoint;
    }
}

