/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.jms.endpoint.JmsEndpointConfiguration;
import org.citrusframework.messaging.AbstractSelectiveMessageConsumer;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConsumer
extends AbstractSelectiveMessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsConsumer.class);
    protected final JmsEndpointConfiguration endpointConfiguration;

    public JmsConsumer(String name, JmsEndpointConfiguration endpointConfiguration) {
        super(name, (EndpointConfiguration)endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
    }

    public org.citrusframework.message.Message receive(String selector, TestContext context, long timeout) {
        Message receivedJmsMessage;
        this.endpointConfiguration.getJmsTemplate().setReceiveTimeout(timeout);
        if (this.endpointConfiguration.getDestination() != null) {
            receivedJmsMessage = this.receive(this.endpointConfiguration.getDestination(), selector);
        } else if (StringUtils.hasText((String)this.endpointConfiguration.getDestinationName())) {
            receivedJmsMessage = this.receive(context.replaceDynamicContentInString(this.endpointConfiguration.getDestinationName()), selector);
        } else if (this.endpointConfiguration.getJmsTemplate().getDefaultDestination() != null) {
            receivedJmsMessage = this.receive(this.endpointConfiguration.getJmsTemplate().getDefaultDestination(), selector);
        } else if (StringUtils.hasText((String)this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName())) {
            receivedJmsMessage = this.receive(context.replaceDynamicContentInString(this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName()), selector);
        } else {
            throw new CitrusRuntimeException("Unable to receive message - JMS destination not set");
        }
        org.citrusframework.message.Message receivedMessage = this.endpointConfiguration.getMessageConverter().convertInbound(receivedJmsMessage, this.endpointConfiguration, context);
        context.onInboundMessage(receivedMessage);
        return receivedMessage;
    }

    private Message receive(String destinationName, String selector) {
        Message receivedJmsMessage;
        if (logger.isDebugEnabled()) {
            logger.debug("Receiving JMS message on destination: '" + this.getDestinationNameWithSelector(destinationName, selector) + "'");
        }
        if ((receivedJmsMessage = StringUtils.hasText((String)selector) ? this.endpointConfiguration.getJmsTemplate().receiveSelected(destinationName, selector) : this.endpointConfiguration.getJmsTemplate().receive(destinationName)) == null) {
            throw new MessageTimeoutException(this.endpointConfiguration.getTimeout(), this.getDestinationNameWithSelector(destinationName, selector));
        }
        logger.info("Received JMS message on destination: '" + this.getDestinationNameWithSelector(destinationName, selector) + "'");
        return receivedJmsMessage;
    }

    private Message receive(Destination destination, String selector) {
        Message receivedJmsMessage;
        if (logger.isDebugEnabled()) {
            logger.debug("Receiving JMS message on destination: '" + this.getDestinationNameWithSelector(this.endpointConfiguration.getDestinationName(destination), selector) + "'");
        }
        if ((receivedJmsMessage = StringUtils.hasText((String)selector) ? this.endpointConfiguration.getJmsTemplate().receiveSelected(destination, selector) : this.endpointConfiguration.getJmsTemplate().receive(destination)) == null) {
            throw new MessageTimeoutException(this.endpointConfiguration.getTimeout(), this.getDestinationNameWithSelector(this.endpointConfiguration.getDestinationName(destination), selector));
        }
        logger.info("Received JMS message on destination: '" + this.getDestinationNameWithSelector(this.endpointConfiguration.getDestinationName(destination), selector) + "'");
        return receivedJmsMessage;
    }

    private String getDestinationNameWithSelector(String destinationName, String selector) {
        return destinationName + (String)(StringUtils.hasText((String)selector) ? "(" + selector + ")" : "");
    }
}

