/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.config.xml;

import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.context.TestContextFactoryBean;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.jms.config.xml.JmsSyncEndpointParser;
import org.citrusframework.jms.endpoint.JmsEndpointAdapter;
import org.citrusframework.jms.endpoint.JmsSyncEndpointConfiguration;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class JmsEndpointAdapterParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JmsEndpointAdapterFactory.class);
        BeanDefinitionBuilder endpointConfiguration = BeanDefinitionBuilder.genericBeanDefinition(JmsSyncEndpointConfiguration.class);
        new JmsSyncEndpointParser().parseEndpointConfiguration(endpointConfiguration, element, parserContext);
        String endpointConfigurationId = element.getAttribute("id") + "EndpointAdapterConfiguration";
        BeanDefinitionParserUtils.registerBean((String)endpointConfigurationId, (BeanDefinition)endpointConfiguration.getBeanDefinition(), (ParserContext)parserContext, (boolean)this.shouldFireEvents());
        builder.addPropertyReference("endpointConfiguration", endpointConfigurationId);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)builder, (String)element.getAttribute("fallback-adapter"), (String)"fallbackEndpointAdapter");
        return builder.getBeanDefinition();
    }

    private static class JmsEndpointAdapterFactory
    implements FactoryBean<JmsEndpointAdapter>,
    BeanNameAware {
        @Autowired(required=false)
        private TestContextFactoryBean testContextFactory;
        private String name;
        private JmsSyncEndpointConfiguration endpointConfiguration;
        private EndpointAdapter fallbackEndpointAdapter;

        private JmsEndpointAdapterFactory() {
        }

        public void setEndpointConfiguration(JmsSyncEndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
        }

        public void setFallbackEndpointAdapter(EndpointAdapter fallbackEndpointAdapter) {
            this.fallbackEndpointAdapter = fallbackEndpointAdapter;
        }

        public JmsEndpointAdapter getObject() throws Exception {
            JmsEndpointAdapter endpointAdapter = new JmsEndpointAdapter(this.endpointConfiguration);
            endpointAdapter.setTestContextFactory((TestContextFactory)this.testContextFactory);
            endpointAdapter.setName(this.name);
            if (this.fallbackEndpointAdapter != null) {
                endpointAdapter.setFallbackEndpointAdapter(this.fallbackEndpointAdapter);
            }
            return endpointAdapter;
        }

        public Class<?> getObjectType() {
            return JmsEndpointAdapter.class;
        }

        public void setBeanName(String name) {
            this.name = name;
        }
    }
}

