/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jbang.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.jbang.JBangSupport;
import org.citrusframework.jbang.ProcessAndOutput;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.validation.ValidationProcessor;
import org.citrusframework.validation.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBangAction
extends AbstractTestAction {
    private final String app;
    private final String scriptOrFile;
    private final List<String> args;
    private final Map<String, String> systemProperties;
    private final int[] exitCodes;
    private final String pidVar;
    private final String outputVar;
    private final String verifyOutput;
    private final ValidationProcessor validationProcessor;
    private final boolean printOutput;
    private static final Logger logger = LoggerFactory.getLogger(JBangAction.class);

    public JBangAction(Builder builder) {
        super("jbang", (AbstractTestActionBuilder)builder);
        this.app = builder.app;
        this.scriptOrFile = builder.scriptOrFile;
        this.args = builder.args;
        this.systemProperties = builder.systemProperties;
        this.exitCodes = builder.exitCodes;
        this.pidVar = builder.pidVar;
        this.outputVar = builder.outputVar;
        this.verifyOutput = builder.verifyOutput;
        this.validationProcessor = builder.validationProcessor;
        this.printOutput = builder.printOutput;
    }

    public void doExecute(TestContext context) {
        String scriptName = FileUtils.getFileName((String)context.replaceDynamicContentInString(this.scriptOrFile));
        logger.info("Running JBang script '%s'".formatted(scriptName));
        ProcessAndOutput result = JBangSupport.jbang().app(this.app).withSystemProperties(context.resolveDynamicValuesInMap(this.systemProperties)).run(context.replaceDynamicContentInString(this.scriptOrFile), context.resolveDynamicValuesInList(this.args));
        if (this.printOutput) {
            logger.info("JBang script '%s' output:".formatted(scriptName));
            logger.info(result.getOutput());
        }
        if (this.pidVar != null) {
            context.setVariable(this.pidVar, (Object)result.getProcessId());
        }
        int exitValue = result.getProcess().exitValue();
        if (Arrays.stream(this.exitCodes).noneMatch(exit -> exit == exitValue)) {
            if (this.exitCodes.length == 1) {
                throw new ValidationException("Error while running JBang script or file. Expected exit code %s, but was %d".formatted(this.exitCodes[0], exitValue));
            }
            throw new ValidationException("Error while running JBang script or file. Expected one of exit codes %s, but was %d".formatted(Arrays.toString(this.exitCodes), exitValue));
        }
        if (this.validationProcessor != null) {
            this.validationProcessor.validate((Message)new DefaultMessage((Object)result.getOutput().trim()).setHeader("pid", (Object)result.getProcessId()).setHeader("exitCode", (Object)result.getProcess().exitValue()), context);
        }
        if (this.verifyOutput != null) {
            ValidationUtils.validateValues((Object)result.getOutput().trim(), (Object)this.verifyOutput, (String)"jbang-output", (TestContext)context);
        }
        if (this.outputVar != null) {
            context.setVariable(context.replaceDynamicContentInString(this.outputVar), (Object)result.getOutput().trim());
        }
        logger.info("JBang script '%s' finished successfully".formatted(scriptName));
    }

    public int[] getExitCodes() {
        return this.exitCodes;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getApp() {
        return this.app;
    }

    public String getScriptOrFile() {
        return this.scriptOrFile;
    }

    public String getOutputVar() {
        return this.outputVar;
    }

    public String getPidVar() {
        return this.pidVar;
    }

    public String getVerifyOutput() {
        return this.verifyOutput;
    }

    public boolean isPrintOutput() {
        return this.printOutput;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public ValidationProcessor getValidationProcessor() {
        return this.validationProcessor;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<JBangAction, Builder> {
        private String app;
        private String scriptOrFile;
        private final List<String> args = new ArrayList<String>();
        private final Map<String, String> systemProperties = new HashMap<String, String>();
        private int[] exitCodes = new int[]{0, 1};
        private String pidVar;
        private String outputVar;
        private String verifyOutput;
        private ValidationProcessor validationProcessor;
        private boolean printOutput = true;

        public static Builder jbang() {
            return new Builder();
        }

        public Builder app(String name) {
            this.app = name;
            return this;
        }

        public Builder command(String command) {
            this.scriptOrFile = command;
            return this;
        }

        public Builder script(String script) {
            this.scriptOrFile = script;
            return this;
        }

        public Builder file(String path) {
            this.scriptOrFile = Resources.create((String)path).getFile().getAbsolutePath();
            return this;
        }

        public Builder file(Resource resource) {
            this.scriptOrFile = resource.getFile().getAbsolutePath();
            return this;
        }

        public Builder arg(String name, String value) {
            this.args.add("%s=%s".formatted(name, value));
            return this;
        }

        public Builder arg(String value) {
            this.args.add(value);
            return this;
        }

        public Builder args(String ... args) {
            this.args.addAll(List.of(args));
            return this;
        }

        public Builder systemProperty(String name, String value) {
            this.systemProperties.put(name, value);
            return this;
        }

        public Builder exitCode(int code) {
            this.exitCodes = new int[]{code};
            return this;
        }

        public Builder exitCodes(int ... codes) {
            this.exitCodes = codes;
            return this;
        }

        public Builder printOutput(boolean enabled) {
            this.printOutput = enabled;
            return this;
        }

        public Builder verifyOutput(String expected) {
            this.verifyOutput = expected;
            return this;
        }

        public Builder verifyOutput(ValidationProcessor validationProcessor) {
            this.validationProcessor = validationProcessor;
            return this;
        }

        public Builder savePid(String variable) {
            this.pidVar = variable;
            return this;
        }

        public Builder saveOutput(String variable) {
            this.outputVar = variable;
            return this;
        }

        public JBangAction build() {
            return new JBangAction(this);
        }
    }
}

