/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.DefaultHeaderValidator;
import org.citrusframework.validation.context.HeaderValidationContext;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;

public class HttpQueryParamHeaderValidator
extends DefaultHeaderValidator {
    public void validateHeader(String name, Object received, Object control, TestContext context, HeaderValidationContext validationContext) {
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)Optional.ofNullable(control).map(Object::toString).orElse(""))) {
            super.validateHeader("citrus_http_query_params", received, control, context, validationContext);
            return;
        }
        Map<String, Object> receiveParams = this.convertToMap(received);
        Map<String, Object> controlParams = this.convertToMap(control);
        for (Map.Entry<String, Object> param : controlParams.entrySet()) {
            if (!receiveParams.containsKey(param.getKey())) {
                throw new ValidationException("Validation failed: Query param '" + param.getKey() + "' is missing");
            }
            super.validateHeaderArray("citrus_http_query_params(" + param.getKey() + ")", receiveParams.get(param.getKey()), param.getValue(), context, validationContext);
        }
    }

    private Map<String, Object> convertToMap(Object expression) {
        if (expression instanceof Map) {
            return (Map)expression;
        }
        return Stream.of(Optional.ofNullable(expression).map(Object::toString).orElse("").split(",")).map(keyValue -> keyValue.split("=")).filter(keyValue -> StringUtils.hasText((String)keyValue[0])).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> ((String[])keyValue).length < 2 ? "" : keyValue[1], (existingValue, newValue) -> {
            if (existingValue instanceof List) {
                ((List)existingValue).add(newValue.toString());
                return existingValue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)existingValue);
            list.add(newValue.toString());
            return list;
        }));
    }

    public boolean supports(String headerName, Class<?> type) {
        return headerName.equals("citrus_http_query_params");
    }
}

