/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.client;

import java.net.URI;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.endpoint.PollableEndpointConfiguration;
import org.citrusframework.exceptions.MessageTimeoutException;
import org.citrusframework.http.client.HttpEndpointConfiguration;
import org.citrusframework.http.client.HttpErrorPropagatingException;
import org.citrusframework.http.interceptor.LoggingClientInterceptor;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.PollingCorrelationManager;
import org.citrusframework.messaging.Producer;
import org.citrusframework.messaging.ReplyConsumer;
import org.citrusframework.messaging.SelectiveConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpClient
extends AbstractEndpoint
implements Producer,
ReplyConsumer {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private CorrelationManager<Message> correlationManager;

    public HttpClient() {
        this(new HttpEndpointConfiguration());
    }

    public HttpClient(HttpEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    public HttpEndpointConfiguration getEndpointConfiguration() {
        return (HttpEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void send(Message message, TestContext context) {
        this.getEndpointConfiguration().getClientInterceptors().stream().filter(LoggingClientInterceptor.class::isInstance).map(LoggingClientInterceptor.class::cast).filter(interceptor -> !interceptor.hasMessageListeners()).forEach(interceptor -> interceptor.setMessageListener(context.getMessageListeners()));
        HttpMessage httpMessage = message instanceof HttpMessage ? (HttpMessage)message : new HttpMessage(message);
        String correlationKeyName = this.getCorrelationKeyName();
        String correlationKey = this.getEndpointConfiguration().getCorrelator().getCorrelationKey((Message)httpMessage);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        String endpointUri = this.getEndpointUri(httpMessage);
        context.setVariable("citrus_message_replyTo_" + correlationKeyName, (Object)endpointUri);
        logger.info("Sending HTTP message to: '{}'", (Object)endpointUri);
        logger.debug("Message to send:\n{}", httpMessage.getPayload(String.class));
        RequestMethod method = this.getEndpointConfiguration().getRequestMethod();
        if (httpMessage.getRequestMethod() != null) {
            method = httpMessage.getRequestMethod();
        }
        HttpEntity<?> requestEntity = this.getEndpointConfiguration().getMessageConverter().convertOutbound((Message)httpMessage, this.getEndpointConfiguration(), context);
        try {
            MediaType accept = Optional.ofNullable(httpMessage.getAccept()).map(mediaType -> mediaType.split(",")).map(mediaType -> {
                try {
                    return MediaType.valueOf((String)mediaType[0]);
                }
                catch (InvalidMediaTypeException e) {
                    logger.warn("Failed to parse accept media type '{}' - using default media type '{}'!", new Object[]{mediaType[0], "*/*", e});
                    return MediaType.ALL;
                }
            }).orElse(MediaType.ALL);
            ResponseEntity response = this.getEndpointConfiguration().getBinaryMediaTypes().stream().anyMatch(mediaType -> mediaType.includes(accept)) ? this.getEndpointConfiguration().getRestTemplate().exchange(URI.create(endpointUri), HttpMethod.valueOf((String)method.toString()), requestEntity, byte[].class) : this.getEndpointConfiguration().getRestTemplate().exchange(URI.create(endpointUri), HttpMethod.valueOf((String)method.toString()), requestEntity, String.class);
            logger.debug("HTTP message was sent to endpoint: '{}'", (Object)endpointUri);
            this.correlationManager.store(correlationKey, (Object)this.getEndpointConfiguration().getMessageConverter().convertInbound((HttpEntity<?>)response, this.getEndpointConfiguration(), context));
        }
        catch (HttpErrorPropagatingException e) {
            logger.warn("Caught HTTP rest client exception!", (Throwable)((Object)e));
            logger.debug("Propagating HTTP rest client exception according to error handling strategy");
            HttpMessage responseMessage = this.getEndpointConfiguration().getMessageConverter().convertInbound((HttpEntity<?>)new ResponseEntity((Object)e.getResponseBodyAsString(), (MultiValueMap)e.getResponseHeaders(), e.getStatusCode()), this.getEndpointConfiguration(), context);
            this.correlationManager.store(correlationKey, (Object)responseMessage);
        }
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getCorrelationKeyName(), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.getEndpointConfiguration().getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getCorrelationKeyName(), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        String endpointUri = context.getVariables().containsKey("citrus_message_replyTo_" + selector) ? context.getVariable("citrus_message_replyTo_" + selector) : this.getName();
        if (message == null) {
            throw new MessageTimeoutException(timeout, endpointUri);
        }
        return message;
    }

    public Producer createProducer() {
        return this;
    }

    public SelectiveConsumer createConsumer() {
        return this;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }

    private String getEndpointUri(HttpMessage httpMessage) {
        if (this.getEndpointConfiguration().getEndpointUriResolver() != null) {
            return this.getEndpointConfiguration().getEndpointUriResolver().resolveEndpointUri((Message)httpMessage, this.getEndpointConfiguration().getRequestUrl());
        }
        return this.getEndpointConfiguration().getRequestUrl();
    }

    private String getCorrelationKeyName() {
        return this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName());
    }
}

