/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.actions;

import jakarta.servlet.http.Cookie;
import java.util.Optional;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.actions.http.HttpReceiveResponseMessageBuilderFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.http.message.HttpMessageUtils;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.builder.ReceiveMessageBuilderSupport;
import org.springframework.http.HttpStatusCode;

public class HttpClientResponseActionBuilder
extends ReceiveMessageAction.ReceiveMessageActionBuilder<ReceiveMessageAction, HttpMessageBuilderSupport, HttpClientResponseActionBuilder>
implements org.citrusframework.actions.http.HttpClientResponseActionBuilder<ReceiveMessageAction, HttpMessageBuilderSupport, HttpClientResponseActionBuilder> {
    private final HttpMessage httpMessage;

    public HttpClientResponseActionBuilder() {
        this.httpMessage = new HttpMessage();
        ((HttpMessageBuilderSupport)this.message((MessageBuilder)new HttpMessageBuilder(this.httpMessage))).headerNameIgnoreCase(true);
    }

    public HttpClientResponseActionBuilder(MessageBuilder messageBuilder, HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        ((HttpMessageBuilderSupport)this.message(messageBuilder)).headerNameIgnoreCase(true);
    }

    public HttpMessageBuilderSupport getMessageBuilderSupport() {
        if (this.messageBuilderSupport == null) {
            this.messageBuilderSupport = this.createHttpMessageBuilderSupport();
        }
        return (HttpMessageBuilderSupport)super.getMessageBuilderSupport();
    }

    protected HttpMessageBuilderSupport createHttpMessageBuilderSupport() {
        return new HttpMessageBuilderSupport(this.httpMessage, this);
    }

    public ReceiveMessageAction doBuild() {
        return this.createReceiveMessageAction();
    }

    protected ReceiveMessageAction createReceiveMessageAction() {
        return new ReceiveMessageAction((ReceiveMessageAction.ReceiveMessageActionBuilder)this);
    }

    protected Optional<String> getMessagePayload() {
        if (this.httpMessage.getPayload() instanceof String) {
            return Optional.of((String)this.httpMessage.getPayload(String.class));
        }
        return super.getMessagePayload();
    }

    public static class HttpMessageBuilderSupport
    extends ReceiveMessageBuilderSupport<ReceiveMessageAction, HttpClientResponseActionBuilder, HttpMessageBuilderSupport>
    implements HttpReceiveResponseMessageBuilderFactory<ReceiveMessageAction, HttpMessageBuilderSupport> {
        private final HttpMessage httpMessage;

        protected HttpMessageBuilderSupport(HttpMessage httpMessage, HttpClientResponseActionBuilder delegate) {
            super((ReceiveMessageAction.ReceiveMessageActionBuilder)delegate);
            this.httpMessage = httpMessage;
        }

        public HttpMessageBuilderSupport body(String payload) {
            this.httpMessage.setPayload(payload);
            return this;
        }

        public HttpMessageBuilderSupport name(String name) {
            this.httpMessage.setName(name);
            return (HttpMessageBuilderSupport)super.name(name);
        }

        public HttpMessageBuilderSupport from(Message controlMessage) {
            HttpMessageUtils.copy(controlMessage, this.httpMessage);
            return this;
        }

        public HttpMessageBuilderSupport status(HttpStatusCode status) {
            this.httpMessage.status(status);
            return this;
        }

        public HttpMessageBuilderSupport status(int status) {
            this.status(HttpStatusCode.valueOf((int)status));
            return this;
        }

        public HttpMessageBuilderSupport status(Object status) {
            if (status instanceof HttpStatusCode) {
                HttpStatusCode statusCode = (HttpStatusCode)status;
                return this.status(statusCode);
            }
            throw new CitrusRuntimeException("Invalid status code type: " + status.getClass().getName());
        }

        public HttpMessageBuilderSupport statusCode(int statusCode) {
            this.httpMessage.status(HttpStatusCode.valueOf((int)statusCode));
            return this;
        }

        public HttpMessageBuilderSupport reasonPhrase(String reasonPhrase) {
            this.httpMessage.reasonPhrase(reasonPhrase);
            return this;
        }

        public HttpMessageBuilderSupport version(String version) {
            this.httpMessage.version(version);
            return this;
        }

        public HttpMessageBuilderSupport contentType(String contentType) {
            this.httpMessage.contentType(contentType);
            return this;
        }

        public HttpMessageBuilderSupport cookie(Object o) {
            if (o == null) {
                return this;
            }
            if (!(o instanceof Cookie)) {
                throw new CitrusRuntimeException("Invalid cookie type: " + o.getClass());
            }
            Cookie cookie = (Cookie)o;
            this.httpMessage.cookie(cookie);
            return this;
        }

        public HttpMessageBuilderSupport cookie(Cookie cookie) {
            this.httpMessage.cookie(cookie);
            return this;
        }
    }
}

