/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.actions;

import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.actions.HttpClientResponseActionBuilder;
import org.citrusframework.spi.AbstractReferenceResolverAwareTestActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.util.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;

public class HttpClientActionBuilder
extends AbstractReferenceResolverAwareTestActionBuilder<TestAction>
implements org.citrusframework.actions.http.HttpClientActionBuilder<TestAction, HttpClientActionBuilder> {
    private Endpoint httpClient;
    private String httpClientUri;

    public HttpClientActionBuilder(Endpoint httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClientActionBuilder(String httpClientUri) {
        this.httpClientUri = httpClientUri;
    }

    public HttpClientSendActionBuilder send() {
        return new HttpClientSendActionBuilder();
    }

    public HttpClientReceiveActionBuilder receive() {
        return new HttpClientReceiveActionBuilder();
    }

    public HttpClientRequestActionBuilder request(HttpMethod method, String path) {
        return this.request(method.name(), path);
    }

    public HttpClientRequestActionBuilder request(String method, String path) {
        HttpClientRequestActionBuilder builder = new HttpClientRequestActionBuilder();
        if (this.httpClient != null) {
            builder.endpoint(this.httpClient);
        } else {
            builder.endpoint(this.httpClientUri);
        }
        builder.name("http:send-request");
        builder.withReferenceResolver(this.referenceResolver);
        builder.method(method);
        if (StringUtils.hasText((String)path)) {
            builder.path(path);
        }
        this.delegate = builder;
        return builder;
    }

    public HttpClientActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull((Object)this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public class HttpClientSendActionBuilder
    implements org.citrusframework.actions.http.HttpClientSendActionBuilder<SendMessageAction, HttpClientRequestActionBuilder.HttpMessageBuilderSupport, HttpClientRequestActionBuilder> {
        public HttpClientRequestActionBuilder get() {
            return HttpClientActionBuilder.this.request(HttpMethod.GET, null);
        }

        public HttpClientRequestActionBuilder get(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.GET, path);
        }

        public HttpClientRequestActionBuilder post() {
            return HttpClientActionBuilder.this.request(HttpMethod.POST, null);
        }

        public HttpClientRequestActionBuilder post(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.POST, path);
        }

        public HttpClientRequestActionBuilder put() {
            return HttpClientActionBuilder.this.request(HttpMethod.PUT, null);
        }

        public HttpClientRequestActionBuilder put(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.PUT, path);
        }

        public HttpClientRequestActionBuilder delete() {
            return HttpClientActionBuilder.this.request(HttpMethod.DELETE, null);
        }

        public HttpClientRequestActionBuilder delete(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.DELETE, path);
        }

        public HttpClientRequestActionBuilder head() {
            return HttpClientActionBuilder.this.request(HttpMethod.HEAD, null);
        }

        public HttpClientRequestActionBuilder head(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.HEAD, path);
        }

        public HttpClientRequestActionBuilder options() {
            return HttpClientActionBuilder.this.request(HttpMethod.OPTIONS, null);
        }

        public HttpClientRequestActionBuilder options(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.OPTIONS, path);
        }

        public HttpClientRequestActionBuilder trace() {
            return HttpClientActionBuilder.this.request(HttpMethod.TRACE, null);
        }

        public HttpClientRequestActionBuilder trace(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.TRACE, path);
        }

        public HttpClientRequestActionBuilder patch() {
            return HttpClientActionBuilder.this.request(HttpMethod.PATCH, null);
        }

        public HttpClientRequestActionBuilder patch(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.PATCH, path);
        }
    }

    public class HttpClientReceiveActionBuilder
    implements org.citrusframework.actions.http.HttpClientReceiveActionBuilder<ReceiveMessageAction, HttpClientResponseActionBuilder.HttpMessageBuilderSupport, HttpClientResponseActionBuilder> {
        public HttpClientResponseActionBuilder response() {
            HttpClientResponseActionBuilder builder = new HttpClientResponseActionBuilder();
            if (HttpClientActionBuilder.this.httpClient != null) {
                builder.endpoint(HttpClientActionBuilder.this.httpClient);
            } else {
                builder.endpoint(HttpClientActionBuilder.this.httpClientUri);
            }
            builder.name("http:receive-response");
            builder.withReferenceResolver(HttpClientActionBuilder.this.referenceResolver);
            HttpClientActionBuilder.this.delegate = (TestActionBuilder)builder;
            return builder;
        }

        public HttpClientResponseActionBuilder response(HttpStatusCode status) {
            return this.response(status.value());
        }

        public HttpClientResponseActionBuilder response(Object status) {
            if (status instanceof HttpStatusCode) {
                HttpStatusCode statusCode = (HttpStatusCode)status;
                return this.response(statusCode);
            }
            throw new CitrusRuntimeException("Invalid status code type: " + status.getClass().getName());
        }

        public HttpClientResponseActionBuilder response(int status) {
            HttpClientResponseActionBuilder builder = new HttpClientResponseActionBuilder();
            if (HttpClientActionBuilder.this.httpClient != null) {
                builder.endpoint(HttpClientActionBuilder.this.httpClient);
            } else {
                builder.endpoint(HttpClientActionBuilder.this.httpClientUri);
            }
            builder.name("http:receive-response");
            builder.withReferenceResolver(HttpClientActionBuilder.this.referenceResolver);
            ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)builder.message()).status(status);
            HttpClientActionBuilder.this.delegate = (TestActionBuilder)builder;
            return builder;
        }
    }
}

