/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.actions;

import jakarta.servlet.http.Cookie;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.http.message.HttpMessageUtils;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.builder.SendMessageBuilderSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public class HttpServerResponseActionBuilder
extends SendMessageAction.SendMessageActionBuilder<SendMessageAction, HttpMessageBuilderSupport, HttpServerResponseActionBuilder> {
    private final HttpMessage httpMessage;

    public HttpServerResponseActionBuilder() {
        this.httpMessage = new HttpMessage();
        this.message((MessageBuilder)new HttpMessageBuilder(this.httpMessage));
    }

    public HttpServerResponseActionBuilder(MessageBuilder messageBuilder, HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.message(messageBuilder);
    }

    public HttpMessageBuilderSupport getMessageBuilderSupport() {
        if (this.messageBuilderSupport == null) {
            this.messageBuilderSupport = new HttpMessageBuilderSupport(this.httpMessage, this);
        }
        return (HttpMessageBuilderSupport)super.getMessageBuilderSupport();
    }

    public SendMessageAction doBuild() {
        return new SendMessageAction((SendMessageAction.SendMessageActionBuilder)this);
    }

    public static class HttpMessageBuilderSupport
    extends SendMessageBuilderSupport<SendMessageAction, HttpServerResponseActionBuilder, HttpMessageBuilderSupport> {
        private final HttpMessage httpMessage;

        protected HttpMessageBuilderSupport(HttpMessage httpMessage, HttpServerResponseActionBuilder delegate) {
            super((SendMessageAction.SendMessageActionBuilder)delegate);
            this.httpMessage = httpMessage;
        }

        public HttpMessageBuilderSupport body(String payload) {
            this.httpMessage.setPayload(payload);
            return this;
        }

        public HttpMessageBuilderSupport name(String name) {
            this.httpMessage.setName(name);
            return (HttpMessageBuilderSupport)super.name(name);
        }

        public HttpMessageBuilderSupport from(Message controlMessage) {
            HttpMessageUtils.copy(controlMessage, this.httpMessage);
            return this;
        }

        public HttpMessageBuilderSupport status(HttpStatus status) {
            this.httpMessage.status((HttpStatusCode)status);
            return this;
        }

        public HttpMessageBuilderSupport statusCode(Integer statusCode) {
            this.httpMessage.status(HttpStatusCode.valueOf((int)statusCode));
            return this;
        }

        public HttpMessageBuilderSupport reasonPhrase(String reasonPhrase) {
            this.httpMessage.reasonPhrase(reasonPhrase);
            return this;
        }

        public HttpMessageBuilderSupport version(String version) {
            this.httpMessage.version(version);
            return this;
        }

        public HttpMessageBuilderSupport contentType(String contentType) {
            this.httpMessage.contentType(contentType);
            return this;
        }

        public HttpMessageBuilderSupport cookie(Cookie cookie) {
            this.httpMessage.cookie(cookie);
            return this;
        }
    }
}

