/*
 * Copyright the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.citrusframework.http.security;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class HttpClientRequestFactoryBean implements FactoryBean<ClientHttpRequestFactory> {

    private final HttpAuthentication auth;
    private String requestUrl;

    public HttpClientRequestFactoryBean(HttpAuthentication auth) {
        this.auth = auth;
    }

    @Override
    public ClientHttpRequestFactory getObject() throws Exception {
        return auth.getRequestFactory(requestUrl, null);
    }

    @Override
    public Class<?> getObjectType() {
        return HttpComponentsClientHttpRequestFactory.class;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }
}
