/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.validation;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.http.model.Control;
import org.citrusframework.http.model.FormData;
import org.citrusframework.http.model.FormMarshaller;
import org.citrusframework.http.model.ObjectFactory;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.xml.XmlMessageValidationContext;
import org.citrusframework.xml.StringResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class FormUrlEncodedMessageValidator
implements MessageValidator<ValidationContext> {
    private static Logger log = LoggerFactory.getLogger(FormUrlEncodedMessageValidator.class);
    public static final String MESSAGE_TYPE = "x-www-form-urlencoded";
    private FormMarshaller formMarshaller = new FormMarshaller();
    private MessageValidator<? extends ValidationContext> xmlMessageValidator;
    private boolean autoDecode = true;
    public static final String DEFAULT_XML_MESSAGE_VALIDATOR = "defaultXmlMessageValidator";

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, List<ValidationContext> validationContexts) throws ValidationException {
        log.info("Start x-www-form-urlencoded message validation");
        try {
            DefaultMessage formMessage = new DefaultMessage(receivedMessage);
            StringResult result = new StringResult();
            this.formMarshaller.marshal(this.createFormData(receivedMessage), (Result)result);
            formMessage.setPayload((Object)result.toString());
            this.getXmlMessageValidator(context).validateMessage((Message)formMessage, controlMessage, context, this.prepareValidationContexts(validationContexts));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Failed to validate x-www-form-urlencoded message", (Throwable)e);
        }
        log.info("Validation of x-www-form-urlencoded message finished successfully: All values OK");
    }

    private List<ValidationContext> prepareValidationContexts(List<ValidationContext> validationContexts) {
        Optional<XmlMessageValidationContext> provided = validationContexts.stream().filter(XmlMessageValidationContext.class::isInstance).map(XmlMessageValidationContext.class::cast).findFirst();
        if (!provided.isPresent()) {
            ArrayList<ValidationContext> enriched = new ArrayList<ValidationContext>(validationContexts);
            enriched.add((ValidationContext)new XmlMessageValidationContext());
            return enriched;
        }
        return validationContexts;
    }

    private MessageValidator<? extends ValidationContext> getXmlMessageValidator(TestContext context) {
        if (this.xmlMessageValidator != null) {
            return this.xmlMessageValidator;
        }
        Optional<MessageValidator> defaultMessageValidator = context.getMessageValidatorRegistry().findMessageValidator(DEFAULT_XML_MESSAGE_VALIDATOR);
        if (!defaultMessageValidator.isPresent() && context.getReferenceResolver().isResolvable(DEFAULT_XML_MESSAGE_VALIDATOR)) {
            defaultMessageValidator = Optional.of((MessageValidator)context.getReferenceResolver().resolve(DEFAULT_XML_MESSAGE_VALIDATOR, MessageValidator.class));
        }
        if (!defaultMessageValidator.isPresent()) {
            defaultMessageValidator = MessageValidator.lookup((String)"xml");
        }
        if (defaultMessageValidator.isPresent()) {
            this.xmlMessageValidator = (MessageValidator)defaultMessageValidator.get();
            return this.xmlMessageValidator;
        }
        throw new CitrusRuntimeException("Unable to locate proper XML message validator - please add validator to project");
    }

    private FormData createFormData(Message message) {
        FormData formData;
        block7: {
            block6: {
                formData = new ObjectFactory().createFormData();
                formData.setContentType(this.getFormContentType(message));
                formData.setAction(this.getFormAction(message));
                if (!(message.getPayload() instanceof MultiValueMap)) break block6;
                MultiValueMap formValueMap = (MultiValueMap)message.getPayload(MultiValueMap.class);
                for (Map.Entry entry : formValueMap.entrySet()) {
                    Control control = new ObjectFactory().createControl();
                    control.setName((String)entry.getKey());
                    control.setValue(StringUtils.arrayToCommaDelimitedString((Object[])((List)entry.getValue()).toArray()));
                    formData.addControl(control);
                }
                break block7;
            }
            String rawFormData = (String)message.getPayload(String.class);
            if (!StringUtils.hasText((String)rawFormData)) break block7;
            StringTokenizer tokenizer = new StringTokenizer(rawFormData, "&");
            while (tokenizer.hasMoreTokens()) {
                Control control = new ObjectFactory().createControl();
                String[] nameValuePair = tokenizer.nextToken().split("=");
                if (this.autoDecode) {
                    try {
                        control.setName(URLDecoder.decode(nameValuePair[0], this.getEncoding()));
                        control.setValue(URLDecoder.decode(nameValuePair[1], this.getEncoding()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new CitrusRuntimeException(String.format("Failed to decode form control value '%s=%s'", nameValuePair[0], nameValuePair[1]), (Throwable)e);
                    }
                } else {
                    control.setName(nameValuePair[0]);
                    control.setValue(nameValuePair[1]);
                }
                formData.addControl(control);
            }
        }
        return formData;
    }

    private String getEncoding() {
        return System.getProperty("citrus.file.encoding", System.getenv("CITRUS_FILE_ENCODING") != null ? System.getenv("CITRUS_FILE_ENCODING") : Charset.defaultCharset().displayName());
    }

    private String getFormAction(Message message) {
        return message.getHeader("citrus_http_request_uri") != null ? message.getHeader("citrus_http_request_uri").toString() : null;
    }

    private String getFormContentType(Message message) {
        return message.getHeader("Content-Type") != null ? message.getHeader("Content-Type").toString() : null;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return MESSAGE_TYPE.equalsIgnoreCase(messageType);
    }
}

