/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.servlet;

import java.util.ArrayList;
import java.util.List;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.http.client.HttpEndpointConfiguration;
import org.citrusframework.http.controller.HttpMessageController;
import org.citrusframework.http.interceptor.DelegatingHandlerInterceptor;
import org.citrusframework.http.interceptor.LoggingHandlerInterceptor;
import org.citrusframework.http.interceptor.MappedInterceptorAdapter;
import org.citrusframework.http.message.DelegatingHttpEntityMessageConverter;
import org.citrusframework.http.server.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.handler.WebRequestHandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;

public class CitrusDispatcherServlet
extends DispatcherServlet {
    private static Logger log = LoggerFactory.getLogger(CitrusDispatcherServlet.class);
    private HttpServer httpServer;
    protected static final String LOGGING_INTERCEPTOR_BEAN_NAME = "citrusLoggingInterceptor";
    protected static final String HANDLER_INTERCEPTOR_BEAN_NAME = "citrusHandlerInterceptor";
    protected static final String MESSAGE_CONTROLLER_BEAN_NAME = "citrusHttpMessageController";
    protected static final String MESSAGE_CONVERTER_BEAN_NAME = "citrusHttpMessageConverter";

    public CitrusDispatcherServlet(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    protected void initStrategies(ApplicationContext context) {
        super.initStrategies(context);
        this.configureHandlerInterceptor(context);
        this.configureMessageController(context);
        this.configureMessageConverter(context);
    }

    protected void configureHandlerInterceptor(ApplicationContext context) {
        if (context.containsBean(HANDLER_INTERCEPTOR_BEAN_NAME)) {
            DelegatingHandlerInterceptor handlerInterceptor = (DelegatingHandlerInterceptor)context.getBean(HANDLER_INTERCEPTOR_BEAN_NAME, DelegatingHandlerInterceptor.class);
            handlerInterceptor.setInterceptors(this.adaptInterceptors(this.httpServer.getInterceptors(), context));
        }
    }

    protected void configureMessageController(ApplicationContext context) {
        if (context.containsBean(MESSAGE_CONTROLLER_BEAN_NAME)) {
            HttpMessageController messageController = (HttpMessageController)context.getBean(MESSAGE_CONTROLLER_BEAN_NAME, HttpMessageController.class);
            EndpointAdapter endpointAdapter = this.httpServer.getEndpointAdapter();
            HttpEndpointConfiguration endpointConfiguration = new HttpEndpointConfiguration();
            endpointConfiguration.setMessageConverter(this.httpServer.getMessageConverter());
            endpointConfiguration.setHeaderMapper((HeaderMapper<HttpHeaders>)DefaultHttpHeaderMapper.inboundMapper());
            endpointConfiguration.setHandleAttributeHeaders(this.httpServer.isHandleAttributeHeaders());
            endpointConfiguration.setHandleCookies(this.httpServer.isHandleCookies());
            endpointConfiguration.setDefaultStatusCode(this.httpServer.getDefaultStatusCode());
            messageController.setEndpointConfiguration(endpointConfiguration);
            messageController.setResponseCacheSize(this.httpServer.getResponseCacheSize());
            if (endpointAdapter != null) {
                messageController.setEndpointAdapter(endpointAdapter);
            }
        }
    }

    protected void configureMessageConverter(ApplicationContext context) {
        HttpMessageConverter messageConverter;
        if (context.containsBean(MESSAGE_CONVERTER_BEAN_NAME) && (messageConverter = (HttpMessageConverter)context.getBean(MESSAGE_CONVERTER_BEAN_NAME, HttpMessageConverter.class)) instanceof DelegatingHttpEntityMessageConverter) {
            ((DelegatingHttpEntityMessageConverter)messageConverter).setBinaryMediaTypes(this.httpServer.getBinaryMediaTypes());
        }
    }

    private List<HandlerInterceptor> adaptInterceptors(List<Object> interceptors, ApplicationContext context) {
        ArrayList<HandlerInterceptor> handlerInterceptors = new ArrayList<HandlerInterceptor>();
        if (context.containsBean(LOGGING_INTERCEPTOR_BEAN_NAME)) {
            LoggingHandlerInterceptor loggingInterceptor = (LoggingHandlerInterceptor)context.getBean(LOGGING_INTERCEPTOR_BEAN_NAME, LoggingHandlerInterceptor.class);
            handlerInterceptors.add(loggingInterceptor);
        }
        if (interceptors != null) {
            for (Object interceptor : interceptors) {
                if (interceptor instanceof MappedInterceptor) {
                    handlerInterceptors.add(new MappedInterceptorAdapter((MappedInterceptor)interceptor, new UrlPathHelper(), (PathMatcher)new AntPathMatcher()));
                    continue;
                }
                if (interceptor instanceof HandlerInterceptor) {
                    handlerInterceptors.add((HandlerInterceptor)interceptor);
                    continue;
                }
                if (interceptor instanceof WebRequestInterceptor) {
                    handlerInterceptors.add((HandlerInterceptor)new WebRequestHandlerInterceptorAdapter((WebRequestInterceptor)interceptor));
                    continue;
                }
                log.warn("Unsupported interceptor type: {}", (Object)interceptor.getClass().getName());
            }
        }
        return handlerInterceptors;
    }
}

